/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import org.junit.Assert;
import org.junit.Test;

public class OpAsQueryTest {
    @Test
    public void testCountStar() {
        Object[] result = this.checkQuery("select (count(*) as ?cs) { ?s ?p ?o }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testCountGroup() {
        Object[] result = this.checkQuery("select (count(?p) as ?cp) { ?s ?p ?o } group by ?s");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testCountGroupAs() {
        Object[] result = this.checkQuery("select (count(?p) as ?cp) { ?s ?p ?o }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testDoubleCount() {
        Object[] result = this.checkQuery("select (count(?s) as ?sc) (count(?p) as ?pc) { ?s ?p ?o }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    public Object[] checkQuery(String query) {
        Query orig = QueryFactory.create((String)query, (Syntax)Syntax.syntaxSPARQL_11);
        Op a = Algebra.compile((Query)orig);
        Query got = OpAsQuery.asQuery((Op)a);
        Object[] r = new Object[]{a, Algebra.compile((Query)got)};
        return r;
    }
}

