/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModEngine;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.ARQTestSuite;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.ScriptTestSuiteFactory;
import com.hp.hpl.jena.sparql.junit.SimpleTestRunner;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.sparql.vocabulary.DOAP;
import com.hp.hpl.jena.sparql.vocabulary.FOAF;
import com.hp.hpl.jena.sparql.vocabulary.TestManifest;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.File;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class qtest
extends CmdARQ {
    protected ArgDecl allDecl = new ArgDecl(false, "all");
    protected ArgDecl wgDecl = new ArgDecl(false, "wg", "dawg");
    protected ArgDecl queryDecl = new ArgDecl(true, "query");
    protected ArgDecl dataDecl = new ArgDecl(true, "data");
    protected ArgDecl resultDecl = new ArgDecl(true, "result");
    protected ArgDecl earlDecl = new ArgDecl(false, "earl");
    protected ModEngine modEngine = this.setModEngine();
    protected TestSuite suite = null;
    protected boolean execAllTests = false;
    protected boolean execDAWGTests = false;
    protected String testfileAbs = null;
    protected boolean createEarlReport = false;

    public static void main(String ... argv) {
        ARQ.init();
        try {
            new qtest(argv).mainRun();
        }
        catch (TerminationException ex) {
            System.exit(ex.getCode());
        }
    }

    public qtest(String[] argv) {
        super(argv);
        this.addModule((ArgModuleGeneral)this.modEngine);
        this.getUsage().startCategory("Tests (single query)");
        this.add(this.queryDecl, "--query", "run the given query");
        this.add(this.dataDecl, "--data", "data file to be queried");
        this.add(this.resultDecl, "--result", "file that specifies the expected result");
        this.getUsage().startCategory("Tests (built-in tests)");
        this.add(this.allDecl, "--all", "run all built-in tests");
        this.add(this.wgDecl, "--dawg", "run working group tests");
        this.getUsage().startCategory("Tests (execute test manifest)");
        this.getUsage().addUsage("<manifest>", "run the tests specified in the given manifest");
        this.add(this.earlDecl, "--earl", "create EARL report");
    }

    protected ModEngine setModEngine() {
        return new ModEngine();
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }

    protected String getSummary() {
        return this.getCommandName() + " [ --data=<file> --query=<query> --result=<results> ] | --all | --dawg | <manifest>";
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(this.queryDecl) || this.contains(this.dataDecl) || this.contains(this.resultDecl)) {
            if (!(this.contains(this.queryDecl) && this.contains(this.dataDecl) && this.contains(this.resultDecl))) {
                throw new CmdException("Must give query, data and result to run a single test");
            }
            String query = this.getValue(this.queryDecl);
            String data = this.getValue(this.dataDecl);
            String result = this.getValue(this.resultDecl);
            this.suite = ScriptTestSuiteFactory.make(query, data, result);
        } else if (this.contains(this.allDecl)) {
            this.execAllTests = true;
        } else if (this.contains(this.wgDecl)) {
            this.execDAWGTests = true;
        } else {
            if (!this.hasPositional()) {
                throw new CmdException("No manifest file");
            }
            String testfile = this.getPositionalArg(0);
            this.testfileAbs = IRIResolver.resolveGlobal((String)testfile);
            this.createEarlReport = this.contains(this.earlDecl);
        }
    }

    protected void exec() {
        if (this.cmdStrictMode) {
            ARQ.setStrictMode();
        }
        if (this.suite != null) {
            SimpleTestRunner.runAndReport((Test)this.suite);
        } else if (this.execAllTests) {
            qtest.allTests();
        } else if (this.execDAWGTests) {
            qtest.dawgTests();
        } else {
            NodeValue.VerboseWarnings = false;
            E_Function.WarnOnUnknownFunction = false;
            if (this.createEarlReport) {
                qtest.oneManifestEarl(this.testfileAbs);
            } else {
                qtest.oneManifest(this.testfileAbs);
            }
        }
    }

    static void oneManifest(String testManifest) {
        TestSuite suite = ScriptTestSuiteFactory.make(testManifest);
        SimpleTestRunner.runAndReport((Test)suite);
    }

    static void oneManifestEarl(String testManifest) {
        EarlReport report;
        String name = "ARQ";
        String releaseName = "ARQ2";
        String version = "ARQ-2.2-dev";
        String homepage = "http://jena.sf.net/ARQ";
        ScriptTestSuiteFactory.results = report = new EarlReport(name, version, homepage);
        Model model = report.getModel();
        model.setNsPrefix("dawg", TestManifest.getURI());
        Resource jena = model.createResource().addProperty(FOAF.homepage, (RDFNode)model.createResource("http://jena.sf.net/"));
        Resource arq = report.getSystem().addProperty(DCTerms.isPartOf, (RDFNode)jena);
        Resource who = model.createResource(FOAF.Person).addProperty(FOAF.name, "Andy Seaborne").addProperty(FOAF.homepage, (RDFNode)model.createResource("http://www.hpl.hp.com/people/afs"));
        Resource reporter = report.getReporter();
        reporter.addProperty(DC.creator, (RDFNode)who);
        model.setNsPrefix("doap", DOAP.getURI());
        model.setNsPrefix("xsd", XSD.getURI());
        Resource system = report.getSystem();
        system.addProperty(RDF.type, (RDFNode)DOAP.Project);
        system.addProperty(DOAP.name, name);
        system.addProperty(DOAP.homepage, homepage);
        system.addProperty(DOAP.maintainer, (RDFNode)who);
        Resource release = model.createResource(DOAP.Version);
        system.addProperty(DOAP.release, (RDFNode)release);
        Node today_node = NodeFactory.todayAsDate();
        Literal today = model.createTypedLiteral(today_node.getLiteralLexicalForm(), today_node.getLiteralDatatype());
        release.addProperty(DOAP.created, (RDFNode)today);
        release.addProperty(DOAP.name, releaseName);
        TestSuite suite = ScriptTestSuiteFactory.make(testManifest);
        SimpleTestRunner.runSilent((Test)suite);
        ScriptTestSuiteFactory.results.getModel().write((OutputStream)System.out, "TTL");
    }

    static void allTests() {
        qtest.ensureDirExists("testing");
        qtest.ensureDirExists("testing/ARQ");
        qtest.ensureDirExists("testing/DAWG");
        TestSuite ts = ARQTestSuite.suite();
        TestRunner.run((Test)ts);
    }

    static void dawgTests() {
        System.err.println("DAWG tests not packaged up yet");
    }

    static void ensureDirExists(String dirname) {
        File f = new File(dirname);
        if (!f.exists() || !f.isDirectory()) {
            System.err.println("Can't find required directory: '" + dirname + "'");
            throw new TerminationException(8);
        }
    }
}

