/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.BadURIException;
import com.hp.hpl.jena.xmloutput.PrettyWriterTest;
import com.hp.hpl.jena.xmloutput.TestEntityOutput;
import com.hp.hpl.jena.xmloutput.TestLiteralEncoding;
import com.hp.hpl.jena.xmloutput.TestMacEncodings;
import com.hp.hpl.jena.xmloutput.TestWriterFeatures;
import com.hp.hpl.jena.xmloutput.testWriterAndReader;
import com.hp.hpl.jena.xmloutput.testWriterInterface;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPackage
extends TestCase {
    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)TestMacEncodings.suite());
        suite.addTestSuite(PrettyWriterTest.class);
        suite.addTest((Test)new testWriterInterface("testInterface", null));
        suite.addTest((Test)new testWriterInterface("testNoWriter", null));
        suite.addTest((Test)new testWriterInterface("testAnotherWriter", null));
        suite.addTest((Test)testWriterAndReader.suiteXML());
        suite.addTest(testWriterAndReader.suiteXML_ABBREV());
        suite.addTest(testWriterAndReader.suiteN_TRIPLE());
        suite.addTestSuite(TestURIExceptions.class);
        suite.addTestSuite(TestEntityOutput.class);
        suite.addTestSuite(TestLiteralEncoding.class);
        suite.addTestSuite(TestWriterFeatures.class);
        return suite;
    }

    public static class TestURIExceptions
    extends TestCase {
        public TestURIExceptions(String name) {
            super(name);
        }

        public void testBadURIExceptionContainsBadURIInMessage() {
            String badURI = "http:";
            Model m = ModelFactory.createDefaultModel();
            m.add(m.createResource(badURI), m.createProperty("eg:B C"), (RDFNode)m.createResource("eg:C D"));
            try {
                m.write((Writer)new StringWriter());
                TestURIExceptions.fail((String)("should detect bad URI " + badURI));
            }
            catch (BadURIException e) {
                TestURIExceptions.assertTrue((String)"message must contain failing URI", (e.getMessage().indexOf(badURI) > 0 ? (byte)1 : 0) != 0);
            }
        }
    }
}

