/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput;

import com.hp.hpl.jena.rdf.arp.MoreTests;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.xmloutput.XMLOutputTestBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMacEncodings
extends ModelTestBase {
    private static Logger logger = LoggerFactory.getLogger(TestMacEncodings.class);
    private static boolean InUse = false;

    public TestMacEncodings(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite(TestMacEncodings.class);
        suite.setName("Encodings (particular MacRoman etc.)");
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new OutputStreamWriter((OutputStream)out, "MacRoman");
            InUse = true;
        }
        catch (Exception e) {
            InUse = false;
        }
        if (!InUse) {
            logger.warn("MacRoman not supported on this Java installation: mac encoding tests suppressed.");
            return suite;
        }
        suite.addTest((Test)new MoreTests("testARPMacRoman"));
        suite.addTest((Test)new MoreTests("testARPMacArabic"));
        return suite;
    }

    public void testXMLWriterMacRoman() throws IOException {
        if (!InUse) {
            return;
        }
        XMLOutputTestBase.blockLogger();
        Model m = TestMacEncodings.createMemModel();
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, "MacRoman");
        m.write((Writer)w, "RDF/XML");
        TestMacEncodings.assertTrue((boolean)XMLOutputTestBase.unblockLogger());
    }

    public void testXMLWriteMacArabic() throws IOException {
        if (!InUse) {
            return;
        }
        XMLOutputTestBase.blockLogger();
        Model m = TestMacEncodings.createMemModel();
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, "MacRoman");
        m.write((Writer)w, "RDF/XML");
        TestMacEncodings.assertTrue((boolean)XMLOutputTestBase.unblockLogger());
    }
}

