/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.CannotEncodeCharacterException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class TestLiteralEncoding
extends ModelTestBase {
    public TestLiteralEncoding(String name) {
        super(name);
    }

    public void testX() {
        TestLiteralEncoding.assertEquals((String)"", (String)Util.substituteEntitiesInElementContent((String)""));
        TestLiteralEncoding.assertEquals((String)"abc", (String)Util.substituteEntitiesInElementContent((String)"abc"));
        TestLiteralEncoding.assertEquals((String)"a&lt;b", (String)Util.substituteEntitiesInElementContent((String)"a<b"));
        TestLiteralEncoding.assertEquals((String)"a&gt;b", (String)Util.substituteEntitiesInElementContent((String)"a>b"));
        TestLiteralEncoding.assertEquals((String)"a&amp;b", (String)Util.substituteEntitiesInElementContent((String)"a&b"));
        TestLiteralEncoding.assertEquals((String)"a;b", (String)Util.substituteEntitiesInElementContent((String)"a;b"));
        TestLiteralEncoding.assertEquals((String)"a b", (String)Util.substituteEntitiesInElementContent((String)"a b"));
        TestLiteralEncoding.assertEquals((String)"a\nb", (String)Util.substituteEntitiesInElementContent((String)"a\nb"));
        TestLiteralEncoding.assertEquals((String)"a'b", (String)Util.substituteEntitiesInElementContent((String)"a'b"));
        TestLiteralEncoding.assertEquals((String)"a&lt;b&lt;c", (String)Util.substituteEntitiesInElementContent((String)"a<b<c"));
        TestLiteralEncoding.assertEquals((String)"a&lt;b&gt;c", (String)Util.substituteEntitiesInElementContent((String)"a<b>c"));
        TestLiteralEncoding.assertEquals((String)"a&lt;b&amp;c", (String)Util.substituteEntitiesInElementContent((String)"a<b&c"));
        TestLiteralEncoding.assertEquals((String)"a&amp;b&amp;c", (String)Util.substituteEntitiesInElementContent((String)"a&b&c"));
        TestLiteralEncoding.assertEquals((String)"a&amp;b&gt;c", (String)Util.substituteEntitiesInElementContent((String)"a&b>c"));
        TestLiteralEncoding.assertEquals((String)"a&amp;b&lt;c", (String)Util.substituteEntitiesInElementContent((String)"a&b<c"));
        TestLiteralEncoding.assertEquals((String)"&#xD;", (String)Util.substituteEntitiesInElementContent((String)"\r"));
        TestLiteralEncoding.assertEquals((String)"\n", (String)Util.substituteEntitiesInElementContent((String)"\n"));
        TestLiteralEncoding.assertEquals((String)"", (String)Util.substituteStandardEntities((String)""));
        TestLiteralEncoding.assertEquals((String)"&lt;", (String)Util.substituteStandardEntities((String)"<"));
        TestLiteralEncoding.assertEquals((String)"&gt;", (String)Util.substituteStandardEntities((String)">"));
        TestLiteralEncoding.assertEquals((String)"&amp;", (String)Util.substituteStandardEntities((String)"&"));
        TestLiteralEncoding.assertEquals((String)"&apos;", (String)Util.substituteStandardEntities((String)"'"));
        TestLiteralEncoding.assertEquals((String)"&quot;", (String)Util.substituteStandardEntities((String)"\""));
        TestLiteralEncoding.assertEquals((String)"&#xA;", (String)Util.substituteStandardEntities((String)"\n"));
        TestLiteralEncoding.assertEquals((String)"&#xD;", (String)Util.substituteStandardEntities((String)"\r"));
        TestLiteralEncoding.assertEquals((String)"&#9;", (String)Util.substituteStandardEntities((String)"\t"));
        TestLiteralEncoding.assertEquals((String)"a&lt;b&amp;c&gt;d", (String)Util.substituteStandardEntities((String)"a<b&c>d"));
    }

    public void testLexicalEncodingException(String lang) {
        for (char ch = '\u0000'; ch < ' '; ch = (char)((char)(ch + 1))) {
            if (ch == 10 || ch == 9 || ch == 13) continue;
            this.testThrowsBadCharacterException(ch, lang);
        }
        this.testThrowsBadCharacterException('\uffff', lang);
        this.testThrowsBadCharacterException('\ufffe', lang);
    }

    public void testBasicLexicalEncodingException() {
        this.testLexicalEncodingException("RDF/XML");
    }

    public void testPrettyLexicalEncodingException() {
        this.testLexicalEncodingException("RDF/XML-ABBREV");
    }

    private void testThrowsBadCharacterException(char badChar, String lang) {
        String badString = "" + badChar;
        Model m = ModelFactory.createDefaultModel();
        m.createResource().addProperty(RDF.value, badString);
        Writer w = new Writer(){

            public void close() throws IOException {
            }

            public void flush() throws IOException {
            }

            public void write(char[] arg0, int arg1, int arg2) throws IOException {
            }
        };
        try {
            m.write(w, lang);
            TestLiteralEncoding.fail((String)("should trap bad character: (char)" + badChar));
        }
        catch (CannotEncodeCharacterException e) {
            TestLiteralEncoding.assertEquals((char)badChar, (char)e.getBadChar());
            TestLiteralEncoding.assertEquals((String)"XML", (String)e.getEncodingContext());
        }
    }

    public void testNoApparentCData() {
        Model m = TestLiteralEncoding.modelWithStatements("a R ']]>'");
        StringWriter s = new StringWriter();
        m.write((Writer)s, "RDF/XML-ABBREV");
        Model m2 = TestLiteralEncoding.modelWithStatements("");
        m2.read((Reader)new StringReader(s.toString()), null, "RDF/XML");
        TestLiteralEncoding.assertIsoModels(m, m2);
        TestLiteralEncoding.assertTrue((s.toString().indexOf("]]&gt;") >= 0 ? (byte)1 : 0) != 0);
        TestLiteralEncoding.assertFalse((s.toString().indexOf("]]>") >= 0 ? (byte)1 : 0) != 0);
    }
}

