/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.rdf.model.impl.Util;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class TestUtil {
    public static Test suite() {
        return new JUnit4TestAdapter(TestUtil.class);
    }

    @org.junit.Test
    public void splitNS_01() {
        TestUtil.split("http://example/xyz", "http://example/", "xyz");
    }

    @org.junit.Test
    public void splitNS_02() {
        TestUtil.split("http://example/ns#xyz", "http://example/ns#", "xyz");
    }

    @org.junit.Test
    public void splitNS_03() {
        TestUtil.no_split("http://example/ns#");
    }

    @org.junit.Test
    public void splitNS_04() {
        TestUtil.no_split("http://example/");
    }

    @org.junit.Test
    public void splitNS_05() {
        TestUtil.split("http://example", "http://", "example");
    }

    @org.junit.Test
    public void splitNS_06() {
        TestUtil.split("mailto:me", "mailto:m", "e");
    }

    @org.junit.Test
    public void splitNS_07() {
        TestUtil.split("urn:abc:xyz", "urn:abc:", "xyz");
    }

    @org.junit.Test
    public void splitNS_08() {
        TestUtil.no_split("urn:abc:xyz:");
    }

    @org.junit.Test
    public void splitNS_09() {
        TestUtil.split("http://bio2rdf.org/pdb:Pentane-3%2C4-diol-5-phosphate", "http://bio2rdf.org/pdb:Pentane-3%2C4-", "diol-5-phosphate");
    }

    @org.junit.Test
    public void splitNS_10() {
        TestUtil.split("http://bio2rdf.org/pdb:Pentane-3,4-diol-5-phosphate", "http://bio2rdf.org/pdb:Pentane-3,4-", "diol-5-phosphate");
    }

    @org.junit.Test
    public void splitNS_11() {
        TestUtil.split("http://host/abc%AAdef", "http://host/abc%AA", "def");
    }

    @org.junit.Test
    public void splitNS_12() {
        TestUtil.split("http://host/abc%1Adef", "http://host/abc%1A", "def");
    }

    @org.junit.Test
    public void splitNS_13() {
        TestUtil.split("http://host/abc%A1def", "http://host/abc%A1", "def");
    }

    @org.junit.Test
    public void splitNS_14() {
        TestUtil.split("http://host/abc%AA22def", "http://host/abc%AA22", "def");
    }

    @org.junit.Test
    public void splitNS_15() {
        TestUtil.no_split("http://host/abc%AA22");
    }

    @org.junit.Test
    public void splitNS_50() {
        TestUtil.split("file:///x/y", "file:///x/", "y");
    }

    @org.junit.Test
    public void splitNS_51() {
        TestUtil.split("file:///x", "file:///", "x");
    }

    @org.junit.Test
    public void splitNS_52() {
        TestUtil.split("file:x", "file:", "x");
    }

    @org.junit.Test
    public void splitNS_53() {
        TestUtil.split("file:foo", "file:", "foo");
    }

    @org.junit.Test
    public void splitNS_54() {
        TestUtil.split("file:c:/foo", "file:c:/", "foo");
    }

    @org.junit.Test
    public void splitNS_55() {
        TestUtil.split("urn:uuid:d871c7f4-2926-11b2-8073-a5e169788449", "urn:uuid:", "d871c7f4-2926-11b2-8073-a5e169788449");
    }

    @org.junit.Test
    public void splitNS_56() {
        TestUtil.split("uuid:3cf3e43a-3a5d-40d8-a93c-8697b162a1c0", "uuid:3", "cf3e43a-3a5d-40d8-a93c-8697b162a1c0");
    }

    @org.junit.Test
    public void splitNS_57() {
        TestUtil.split("urn:abc:def", "urn:abc:", "def");
    }

    static void no_split(String string) {
        TestUtil.split(string, null, null);
    }

    static void split(String uriStr, String namespace, String localname) {
        int idx;
        if (namespace == null && localname != null) {
            Assert.fail((String)"Bad test - namespace is null but local name is not");
        }
        if (namespace != null && localname == null) {
            Assert.fail((String)"Bad test - namespace is not null but local name is");
        }
        if ((idx = Util.splitNamespace((String)uriStr)) == uriStr.length()) {
            if (namespace != null) {
                Assert.fail((String)("Expected a split (" + namespace + "," + localname + ") - but none found"));
            }
            return;
        }
        String ns = uriStr.substring(0, idx);
        String ln = uriStr.substring(idx);
        Assert.assertEquals((Object)namespace, (Object)ns);
        Assert.assertEquals((Object)localname, (Object)ln);
    }
}

