/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import com.hp.hpl.jena.graph.test.RecordingListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.RecordingModelListener;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.MonitorGraph;
import com.hp.hpl.jena.util.MonitorModel;
import java.util.ArrayList;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMonitors
extends TestCase {
    String NS = "http://jena.hpl.hp.com/test#";
    Node a = NodeCreateUtils.create(this.NS + "a");
    Node p = NodeCreateUtils.create(this.NS + "p");
    Triple t1 = new Triple(this.a, this.p, NodeCreateUtils.create(this.NS + "v1"));
    Triple t2 = new Triple(this.a, this.p, NodeCreateUtils.create(this.NS + "v2"));
    Triple t3 = new Triple(this.a, this.p, NodeCreateUtils.create(this.NS + "v3"));
    Triple t4 = new Triple(this.a, this.p, NodeCreateUtils.create(this.NS + "v4"));
    Triple t5 = new Triple(this.a, this.p, NodeCreateUtils.create(this.NS + "v5"));
    Triple t6 = new Triple(this.a, this.p, NodeCreateUtils.create(this.NS + "v6"));

    public TestMonitors(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestMonitors.class);
    }

    public void testBasics() {
        Graph base = Factory.createGraphMem();
        MonitorGraph monitor = new MonitorGraph(base);
        base.add(this.t1);
        base.add(this.t2);
        base.add(this.t3);
        ArrayList additions = new ArrayList();
        ArrayList deletions = new ArrayList();
        monitor.snapshot(additions, deletions);
        TestUtil.assertIteratorValues(this, additions.iterator(), new Object[]{this.t1, this.t2, this.t3});
        TestUtil.assertIteratorValues(this, deletions.iterator(), new Object[0]);
        base.add(this.t4);
        base.add(this.t5);
        base.delete(this.t1);
        base.delete(this.t2);
        additions.clear();
        deletions.clear();
        monitor.snapshot(additions, deletions);
        TestUtil.assertIteratorValues(this, additions.iterator(), new Object[]{this.t4, this.t5});
        TestUtil.assertIteratorValues(this, deletions.iterator(), new Object[]{this.t1, this.t2});
        TestUtil.assertIteratorValues(this, monitor.find(Node.ANY, Node.ANY, Node.ANY), new Object[]{this.t3, this.t4, this.t5});
    }

    public void testListener() {
        Graph base = Factory.createGraphMem();
        MonitorGraph monitor = new MonitorGraph(base);
        RecordingListener listener = new RecordingListener();
        monitor.getEventManager().register((GraphListener)listener);
        base.add(this.t1);
        base.add(this.t2);
        base.add(this.t3);
        listener.has(new Object[0]);
        ArrayList additions = new ArrayList();
        ArrayList deletions = new ArrayList();
        monitor.snapshot(additions, deletions);
        TestUtil.assertIteratorValues(this, additions.iterator(), new Object[]{this.t1, this.t2, this.t3});
        TestUtil.assertIteratorValues(this, deletions.iterator(), new Object[0]);
        listener.assertHas(new Object[]{"addList", monitor, additions, "deleteList", monitor, deletions});
        listener.clear();
        base.add(this.t4);
        base.add(this.t5);
        base.delete(this.t1);
        base.delete(this.t2);
        additions.clear();
        deletions.clear();
        monitor.snapshot(additions, deletions);
        TestUtil.assertIteratorValues(this, additions.iterator(), new Object[]{this.t4, this.t5});
        TestUtil.assertIteratorValues(this, deletions.iterator(), new Object[]{this.t1, this.t2});
        TestUtil.assertIteratorValues(this, monitor.find(Node.ANY, Node.ANY, Node.ANY), new Object[]{this.t3, this.t4, this.t5});
        listener.assertHas(new Object[]{"addList", monitor, additions, "deleteList", monitor, deletions});
        listener.clear();
    }

    public void testModelMonitor() {
        Model base = ModelFactory.createDefaultModel();
        Resource ar = base.createResource(this.NS + "a");
        Property pr = base.createProperty(this.NS + "p");
        Statement s1 = base.createStatement(ar, pr, "1");
        Statement s2 = base.createStatement(ar, pr, "2");
        Statement s3 = base.createStatement(ar, pr, "3");
        Statement s4 = base.createStatement(ar, pr, "4");
        Statement s5 = base.createStatement(ar, pr, "5");
        MonitorModel monitor = new MonitorModel(base);
        RecordingModelListener listener = new RecordingModelListener();
        monitor.register((ModelChangedListener)listener);
        base.add(s1);
        base.add(s2);
        base.add(s3);
        ArrayList additions = new ArrayList();
        ArrayList deletions = new ArrayList();
        monitor.snapshot(additions, deletions);
        TestUtil.assertIteratorValues(this, additions.iterator(), new Object[]{s1, s2, s3});
        TestUtil.assertIteratorValues(this, deletions.iterator(), new Object[0]);
        listener.assertHas(new Object[]{"addList", additions, "removeList", deletions});
        listener.clear();
        base.add(s4);
        base.add(s5);
        base.remove(s1);
        base.remove(s2);
        additions.clear();
        deletions.clear();
        monitor.snapshot(additions, deletions);
        TestUtil.assertIteratorValues(this, additions.iterator(), new Object[]{s4, s5});
        TestUtil.assertIteratorValues(this, deletions.iterator(), new Object[]{s1, s2});
        TestUtil.assertIteratorValues(this, monitor.listStatements(), new Object[]{s3, s4, s5});
        listener.assertHas(new Object[]{"addList", additions, "removeList", deletions});
        listener.clear();
    }
}

