/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestIteratorCollection
extends GraphTestBase {
    public TestIteratorCollection(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestIteratorCollection.class);
    }

    public void testEmptyToEmptySet() {
        TestIteratorCollection.assertEquals((Object)CollectionFactory.createHashedSet(), (Object)IteratorCollection.iteratorToSet((Iterator)NullIterator.instance()));
    }

    public void testSingletonToSingleSet() {
        TestIteratorCollection.assertEquals(this.oneSet("single"), TestIteratorCollection.iteratorToSet(new SingletonIterator((Object)"single")));
    }

    public void testLotsToSet() {
        Object[] elements = new Object[]{"now", "is", "the", "time"};
        Iterator<Object> it = Arrays.asList(elements).iterator();
        TestIteratorCollection.assertEquals(this.setLots(elements), (Object)IteratorCollection.iteratorToSet(it));
    }

    public void testCloseForSet() {
        this.testCloseForSet(new Object[0]);
        this.testCloseForSet(new Object[]{"one"});
        this.testCloseForSet(new Object[]{"to", "free", "for"});
        this.testCloseForSet(new Object[]{"another", "one", "plus", Boolean.FALSE});
        this.testCloseForSet(new Object[]{"the", "king", "is", "in", "his", "counting", "house"});
    }

    protected void testCloseForSet(Object[] objects) {
        final boolean[] closed = new boolean[]{false};
        WrappedIterator<Object> iterator = new WrappedIterator<Object>(Arrays.asList(objects).iterator()){

            public void close() {
                super.close();
                closed[0] = true;
            }
        };
        TestIteratorCollection.iteratorToSet(iterator);
        TestIteratorCollection.assertTrue((boolean)closed[0]);
    }

    public void testEmptyToEmptyList() {
        TestIteratorCollection.assertEquals(new ArrayList(), (Object)IteratorCollection.iteratorToList((Iterator)NullIterator.instance()));
    }

    public void testSingletonToSingletonList() {
        TestIteratorCollection.assertEquals(this.oneList("just one"), (Object)IteratorCollection.iteratorToList((Iterator)new SingletonIterator((Object)"just one")));
    }

    public void testLotsToList() {
        List<Object> list = Arrays.asList("to", "be", "or", "not", "to", "be");
        TestIteratorCollection.assertEquals(list, (Object)IteratorCollection.iteratorToList(list.iterator()));
    }

    public void testCloseForList() {
        this.testCloseForList(new Object[0]);
        this.testCloseForList(new Object[]{"one"});
        this.testCloseForList(new Object[]{"to", "free", "for"});
        this.testCloseForList(new Object[]{"another", "one", "plus", Boolean.FALSE});
        this.testCloseForList(new Object[]{"the", "king", "is", "in", "his", "counting", "house"});
    }

    protected void testCloseForList(Object[] objects) {
        final boolean[] closed = new boolean[]{false};
        WrappedIterator<Object> iterator = new WrappedIterator<Object>(Arrays.asList(objects).iterator()){

            public void close() {
                super.close();
                closed[0] = true;
            }
        };
        TestIteratorCollection.iteratorToList(iterator);
        TestIteratorCollection.assertTrue((boolean)closed[0]);
    }

    protected Set<Object> oneSet(Object x) {
        HashSet<Object> result = new HashSet<Object>();
        result.add(x);
        return result;
    }

    protected Set<Object> setLots(Object[] elements) {
        HashSet<Object> result = new HashSet<Object>();
        for (int i = 0; i < elements.length; ++i) {
            result.add(elements[i]);
        }
        return result;
    }

    protected List<Object> oneList(Object x) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(x);
        return result;
    }
}

