/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.test;

import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaTestBase
extends TestCase {
    public JenaTestBase(String name) {
        super(name);
    }

    public void testToSilenceJunitComplaintsAboutNoTestMethods() {
    }

    public static void assertDiffer(String title, Object x, Object y) {
        if (x == null ? y == null : x.equals(y)) {
            JenaTestBase.fail((String)((title == null ? "objects should be different, but both were: " : title) + x));
        }
    }

    public static void assertDiffer(Object x, Object y) {
        JenaTestBase.assertDiffer(null, x, y);
    }

    public static void assertInstanceOf(Class<?> expected, Object x) {
        if (x == null) {
            JenaTestBase.fail((String)("expected instance of " + expected + ", but had null"));
        }
        if (!expected.isInstance(x)) {
            JenaTestBase.fail((String)("expected instance of " + expected + ", but had instance of " + x.getClass()));
        }
    }

    public static <T> Set<T> listToSet(List<T> L) {
        return CollectionFactory.createHashedSet(L);
    }

    public static List<String> listOfStrings(String s) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    public static Set<String> setOfStrings(String s) {
        HashSet<String> result = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    public static <T> List<T> listOfOne(T x) {
        ArrayList<T> result = new ArrayList<T>();
        result.add(x);
        return result;
    }

    public static <T> Set<T> setOfOne(T x) {
        HashSet<T> result = new HashSet<T>();
        result.add(x);
        return result;
    }

    public static <T> List<T> append(List<? extends T> L, List<? extends T> R) {
        ArrayList<T> result = new ArrayList<T>(L);
        result.addAll(R);
        return result;
    }

    protected static ExtendedIterator<String> iteratorOfStrings(String s) {
        return WrappedIterator.create(JenaTestBase.listOfStrings(s).iterator());
    }

    public static void pass() {
    }

    public static Constructor<?> getConstructor(Class<?> c, Class<?>[] args) {
        try {
            return c.getConstructor(args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean isPublicTestMethod(Method m) {
        return Modifier.isPublic(m.getModifiers()) && JenaTestBase.isTestMethod(m);
    }

    public static boolean isTestMethod(Method m) {
        return m.getName().startsWith("test") && m.getParameterTypes().length == 0 && m.getReturnType().equals(Void.TYPE);
    }

    public static boolean hasAsParent(Class<?> subClass, Class<?> superClass) {
        if (subClass == superClass || subClass.getSuperclass() == superClass) {
            return true;
        }
        Class<?>[] is = subClass.getInterfaces();
        for (int i = 0; i < is.length; ++i) {
            if (!JenaTestBase.hasAsParent(is[i], superClass)) continue;
            return true;
        }
        return false;
    }

    public static void assertHasParent(Class<?> subClass, Class<?> superClass) {
        if (!JenaTestBase.hasAsParent(subClass, superClass)) {
            JenaTestBase.fail((String)("" + subClass + " should have " + superClass + " as a parent"));
        }
    }
}

