/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.regression.NewRegressionBase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionSet
extends NewRegressionBase {
    protected Model m;

    public NewRegressionSet(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionSet.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
    }

    public void testUnion() {
        Model m1 = this.getModel();
        Model m2 = this.getModel();
        NewRegressionSet.modelAdd(m1, "a P b; w R x");
        NewRegressionSet.modelAdd(m2, "w R x; y S z");
        Model um = m1.union(m2);
        NewRegressionSet.assertFalse((boolean)m1.containsAll(m2));
        NewRegressionSet.assertFalse((boolean)m2.containsAll(m1));
        NewRegressionSet.assertTrue((boolean)um.containsAll(m1));
        NewRegressionSet.assertTrue((boolean)um.containsAll(m2));
        StmtIterator it = um.listStatements();
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            NewRegressionSet.assertTrue((m1.contains(s) || m2.contains(s) ? 1 : 0) != 0);
        }
        it = m1.listStatements();
        while (it.hasNext()) {
            NewRegressionSet.assertTrue((boolean)um.contains(it.nextStatement()));
        }
        it = m2.listStatements();
        while (it.hasNext()) {
            NewRegressionSet.assertTrue((boolean)um.contains(it.nextStatement()));
        }
        NewRegressionSet.assertTrue((boolean)um.containsAll(m1.listStatements()));
        NewRegressionSet.assertTrue((boolean)um.containsAll(m2.listStatements()));
    }

    public void testIntersection() {
        Model m1 = this.getModel();
        Model m2 = this.getModel();
        NewRegressionSet.modelAdd(m1, "a P b; w R x");
        NewRegressionSet.modelAdd(m2, "w R x; y S z");
        Model im = m1.intersection(m2);
        NewRegressionSet.assertFalse((boolean)m1.containsAll(m2));
        NewRegressionSet.assertFalse((boolean)m2.containsAll(m1));
        NewRegressionSet.assertTrue((boolean)m1.containsAll(im));
        NewRegressionSet.assertTrue((boolean)m2.containsAll(im));
        StmtIterator it = im.listStatements();
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            NewRegressionSet.assertTrue((m1.contains(s) && m2.contains(s) ? 1 : 0) != 0);
        }
        it = im.listStatements();
        while (it.hasNext()) {
            NewRegressionSet.assertTrue((boolean)m1.contains(it.nextStatement()));
        }
        it = im.listStatements();
        while (it.hasNext()) {
            NewRegressionSet.assertTrue((boolean)m2.contains(it.nextStatement()));
        }
        NewRegressionSet.assertTrue((boolean)m1.containsAll(im.listStatements()));
        NewRegressionSet.assertTrue((boolean)m2.containsAll(im.listStatements()));
    }

    public void testDifference() {
        Statement s;
        Model m1 = this.getModel();
        Model m2 = this.getModel();
        NewRegressionSet.modelAdd(m1, "a P b; w R x");
        NewRegressionSet.modelAdd(m2, "w R x; y S z");
        Model dm = m1.difference(m2);
        StmtIterator it = dm.listStatements();
        while (it.hasNext()) {
            s = it.nextStatement();
            NewRegressionSet.assertTrue((m1.contains(s) && !m2.contains(s) ? 1 : 0) != 0);
        }
        it = m1.union(m2).listStatements();
        while (it.hasNext()) {
            s = it.nextStatement();
            NewRegressionSet.assertEquals((m1.contains(s) && !m2.contains(s) ? 1 : 0) != 0, (boolean)dm.contains(s));
        }
        NewRegressionSet.assertTrue((boolean)dm.containsAny(m1));
        NewRegressionSet.assertTrue((boolean)dm.containsAny(m1.listStatements()));
        NewRegressionSet.assertFalse((boolean)dm.containsAny(m2));
        NewRegressionSet.assertFalse((boolean)dm.containsAny(m2.listStatements()));
        NewRegressionSet.assertTrue((boolean)m1.containsAll(dm));
    }
}

