/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.SeqIndexBoundsException;
import com.hp.hpl.jena.regression.NewRegressionBase;
import com.hp.hpl.jena.regression.Regression;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionSeq
extends NewRegressionBase {
    protected Model m;

    public NewRegressionSeq(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionSeq.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
    }

    public void tearDown() {
        this.m = null;
    }

    public void testSeqAdd() {
        Seq seq = this.m.createSeq();
        NewRegressionSeq.assertEquals((int)0, (int)seq.size());
        NewRegressionSeq.assertTrue((boolean)this.m.contains((Resource)seq, RDF.type, (RDFNode)RDF.Seq));
        seq.add(true);
        NewRegressionSeq.assertTrue((boolean)seq.contains(true));
        NewRegressionSeq.assertFalse((boolean)seq.contains(false));
        seq.add(1L);
        NewRegressionSeq.assertTrue((boolean)seq.contains(1L));
        NewRegressionSeq.assertFalse((boolean)seq.contains(101L));
        seq.add(2L);
        NewRegressionSeq.assertTrue((boolean)seq.contains(2L));
        NewRegressionSeq.assertFalse((boolean)seq.contains(102L));
        seq.add(-1L);
        NewRegressionSeq.assertTrue((boolean)seq.contains(-1L));
        NewRegressionSeq.assertFalse((boolean)seq.contains(-101L));
        seq.add(-2L);
        NewRegressionSeq.assertTrue((boolean)seq.contains(-2L));
        NewRegressionSeq.assertFalse((boolean)seq.contains(-102L));
        seq.add('!');
        NewRegressionSeq.assertTrue((boolean)seq.contains('!'));
        NewRegressionSeq.assertFalse((boolean)seq.contains('?'));
        seq.add(123.456f);
        NewRegressionSeq.assertTrue((boolean)seq.contains(123.456f));
        NewRegressionSeq.assertFalse((boolean)seq.contains(456.123f));
        seq.add(-123.456);
        NewRegressionSeq.assertTrue((boolean)seq.contains(-123.456));
        NewRegressionSeq.assertFalse((boolean)seq.contains(-456.123));
        seq.add("a string");
        NewRegressionSeq.assertTrue((boolean)seq.contains("a string"));
        NewRegressionSeq.assertFalse((boolean)seq.contains("a necklace"));
        seq.add((RDFNode)this.m.createLiteral("another string"));
        NewRegressionSeq.assertTrue((boolean)seq.contains("another string"));
        NewRegressionSeq.assertFalse((boolean)seq.contains("another necklace"));
        seq.add((Object)new Regression.LitTestObj(12345L));
        NewRegressionSeq.assertTrue((boolean)seq.contains((Object)new Regression.LitTestObj(12345L)));
        NewRegressionSeq.assertFalse((boolean)seq.contains((Object)new Regression.LitTestObj(54321L)));
        NewRegressionSeq.assertEquals((int)11, (int)seq.size());
    }

    public void testSeqAddInts() {
        int num = 10;
        Seq seq = this.m.createSeq();
        for (int i = 0; i < 10; ++i) {
            seq.add((long)i);
        }
        NewRegressionSeq.assertEquals((int)10, (int)seq.size());
        List L = NewRegressionSeq.iteratorToList(seq.iterator());
        NewRegressionSeq.assertEquals((int)10, (int)L.size());
        for (int i = 0; i < 10; ++i) {
            NewRegressionSeq.assertEquals((int)i, (int)((Literal)L.get(i)).getInt());
        }
    }

    public void testRemoveA() {
        this.testRemove(this.bools("tttffffftt"));
    }

    public void testRemoveB() {
        this.testRemove(this.bools("ftftttttft"));
    }

    public void testRemoveC() {
        this.testRemove(this.bools("ffffffffff"));
    }

    protected boolean[] bools(String s) {
        boolean[] result = new boolean[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            result[i] = s.charAt(i) == 't';
        }
        return result;
    }

    protected void testRemove(boolean[] retain) {
        int num = retain.length;
        Seq seq = this.m.createSeq();
        for (int i = 0; i < num; ++i) {
            seq.add((long)i);
        }
        ArrayList<RDFNode> retained = new ArrayList<RDFNode>();
        NodeIterator nIter = seq.iterator();
        for (int i = 0; i < num; ++i) {
            RDFNode x = nIter.nextNode();
            if (retain[i]) {
                retained.add(x);
                continue;
            }
            nIter.remove();
        }
        NewRegressionSeq.assertFalse((boolean)nIter.hasNext());
        NewRegressionSeq.assertEquals(retained, NewRegressionSeq.iteratorToList(seq.iterator()));
    }

    public void testSeqAccessByIndexing() {
        Regression.LitTestObj tvObject = new Regression.LitTestObj(12345L);
        Literal tvLiteral = this.m.createLiteral("test 12 string 2");
        Resource tvResource = this.m.createResource();
        Regression.LitTestObj tvLitObj = new Regression.LitTestObj(1234L);
        Bag tvBag = this.m.createBag();
        Alt tvAlt = this.m.createAlt();
        Seq tvSeq = this.m.createSeq();
        Seq seq = this.m.createSeq();
        seq.add(true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq.getBoolean(1));
        seq.add(1L);
        NewRegressionSeq.assertEquals((byte)1, (byte)seq.getByte(2));
        seq.add(2L);
        NewRegressionSeq.assertEquals((short)2, (short)seq.getShort(3));
        seq.add(-1L);
        NewRegressionSeq.assertEquals((int)-1, (int)seq.getInt(4));
        seq.add(-2L);
        NewRegressionSeq.assertEquals((long)-2L, (long)seq.getLong(5));
        seq.add('!');
        NewRegressionSeq.assertEquals((char)'!', (char)seq.getChar(6));
        seq.add(123.456f);
        NewRegressionSeq.assertEquals((double)123.456f, (double)seq.getFloat(7), (double)5.0E-5);
        seq.add(12345.6789);
        NewRegressionSeq.assertEquals((double)12345.6789, (double)seq.getDouble(8), (double)5.0E-8);
        seq.add("some string");
        NewRegressionSeq.assertEquals((String)"some string", (String)seq.getString(9));
        seq.add((Object)tvLitObj);
        seq.add((RDFNode)tvResource);
        NewRegressionSeq.assertEquals((Object)tvResource, (Object)seq.getResource(11));
        seq.add((RDFNode)tvLiteral);
        NewRegressionSeq.assertEquals((Object)tvLiteral, (Object)seq.getLiteral(12));
        seq.add((RDFNode)tvBag);
        NewRegressionSeq.assertEquals((Object)tvBag, (Object)seq.getBag(13));
        seq.add((RDFNode)tvAlt);
        NewRegressionSeq.assertEquals((Object)tvAlt, (Object)seq.getAlt(14));
        seq.add((RDFNode)tvSeq);
        NewRegressionSeq.assertEquals((Object)tvSeq, (Object)seq.getSeq(15));
        try {
            seq.getInt(16);
            NewRegressionSeq.fail((String)"there is no element 16");
        }
        catch (SeqIndexBoundsException e) {
            NewRegressionSeq.pass();
        }
        try {
            seq.getInt(0);
            NewRegressionSeq.fail((String)"there is no element 0");
        }
        catch (SeqIndexBoundsException e) {
            NewRegressionSeq.pass();
        }
    }

    public void testSeqInsertByIndexing() {
        Regression.LitTestObj tvObject = new Regression.LitTestObj(12345L);
        Literal tvLiteral = this.m.createLiteral("test 12 string 2");
        Resource tvResource = this.m.createResource();
        Regression.LitTestObj tvLitObj = new Regression.LitTestObj(1234L);
        Bag tvBag = this.m.createBag();
        Alt tvAlt = this.m.createAlt();
        Seq tvSeq = this.m.createSeq();
        Seq seq = this.m.createSeq();
        seq.add((RDFNode)this.m.createResource());
        seq.add(1, true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq.getBoolean(1));
        seq.add(1, 1L);
        NewRegressionSeq.assertEquals((byte)1, (byte)seq.getByte(1));
        seq.add(1, 2L);
        NewRegressionSeq.assertEquals((short)2, (short)seq.getShort(1));
        seq.add(1, -1L);
        NewRegressionSeq.assertEquals((int)-1, (int)seq.getInt(1));
        seq.add(1, -2L);
        NewRegressionSeq.assertEquals((long)-2L, (long)seq.getLong(1));
        seq.add(1, '!');
        NewRegressionSeq.assertEquals((char)'!', (char)seq.getChar(1));
        seq.add(1, 123.456f);
        NewRegressionSeq.assertEquals((double)123.456f, (double)seq.getFloat(1), (double)5.0E-5);
        seq.add(1, 12345.6789);
        NewRegressionSeq.assertEquals((double)12345.6789, (double)seq.getDouble(1), (double)5.0E-8);
        seq.add(1, "some string");
        NewRegressionSeq.assertEquals((String)"some string", (String)seq.getString(1));
        seq.add(1, (Object)tvLitObj);
        seq.add(1, (RDFNode)tvResource);
        NewRegressionSeq.assertEquals((Object)tvResource, (Object)seq.getResource(1));
        seq.add(1, (RDFNode)tvLiteral);
        NewRegressionSeq.assertEquals((Object)tvLiteral, (Object)seq.getLiteral(1));
        seq.add(1, (RDFNode)tvBag);
        NewRegressionSeq.assertEquals((Object)tvBag, (Object)seq.getBag(1));
        seq.add(1, (RDFNode)tvAlt);
        NewRegressionSeq.assertEquals((Object)tvAlt, (Object)seq.getAlt(1));
        seq.add(1, (RDFNode)tvSeq);
        NewRegressionSeq.assertEquals((Object)tvSeq, (Object)seq.getSeq(1));
        NewRegressionSeq.assertEquals((int)0, (int)seq.indexOf(1234543L));
        NewRegressionSeq.assertEquals((int)1, (int)seq.indexOf((RDFNode)tvSeq));
        NewRegressionSeq.assertEquals((int)2, (int)seq.indexOf((RDFNode)tvAlt));
        NewRegressionSeq.assertEquals((int)3, (int)seq.indexOf((RDFNode)tvBag));
        NewRegressionSeq.assertEquals((int)4, (int)seq.indexOf((RDFNode)tvLiteral));
        NewRegressionSeq.assertEquals((int)5, (int)seq.indexOf((RDFNode)tvResource));
        NewRegressionSeq.assertEquals((int)6, (int)seq.indexOf((Object)tvLitObj));
        NewRegressionSeq.assertEquals((int)7, (int)seq.indexOf("some string"));
        NewRegressionSeq.assertEquals((int)8, (int)seq.indexOf(12345.6789));
        NewRegressionSeq.assertEquals((int)9, (int)seq.indexOf(123.456f));
        NewRegressionSeq.assertEquals((int)10, (int)seq.indexOf('!'));
        NewRegressionSeq.assertEquals((int)11, (int)seq.indexOf(-2L));
        NewRegressionSeq.assertEquals((int)12, (int)seq.indexOf(-1L));
        NewRegressionSeq.assertEquals((int)13, (int)seq.indexOf(2L));
        NewRegressionSeq.assertEquals((int)14, (int)seq.indexOf(1L));
        NewRegressionSeq.assertEquals((int)15, (int)seq.indexOf(true));
    }

    public void testMoreIndexing() {
        int num = 10;
        Seq seq = this.m.createSeq();
        for (int i = 0; i < 10; ++i) {
            seq.add((long)i);
        }
        try {
            seq.add(0, false);
            NewRegressionSeq.fail((String)"cannot at at position 0");
        }
        catch (SeqIndexBoundsException e) {
            NewRegressionSeq.pass();
        }
        seq.add(11, false);
        NewRegressionSeq.assertEquals((int)11, (int)seq.size());
        seq.remove(11);
        try {
            seq.add(12, false);
            NewRegressionSeq.fail((String)"cannot add past the end");
        }
        catch (SeqIndexBoundsException e) {
            NewRegressionSeq.pass();
        }
        int size = seq.size();
        for (int i = 1; i <= 9; ++i) {
            seq.add(i, (long)(1000 + i));
            NewRegressionSeq.assertEquals((int)(1000 + i), (int)seq.getInt(i));
            NewRegressionSeq.assertEquals((int)0, (int)seq.getInt(i + 1));
            NewRegressionSeq.assertEquals((int)(size + i), (int)seq.size());
            NewRegressionSeq.assertEquals((int)(10 - i - 1), (int)seq.getInt(size));
        }
    }

    public void testSet() {
        Model m = this.getModel();
        String test = "Test16";
        boolean n = false;
        Literal tvLiteral = m.createLiteral("test 12 string 2");
        Resource tvResource = m.createResource();
        Bag tvBag = m.createBag();
        Alt tvAlt = m.createAlt();
        Seq tvSeq = m.createSeq();
        int num = 10;
        Seq seq = m.createSeq();
        for (int i = 0; i < num; ++i) {
            seq.add((long)i);
        }
        seq.set(5, true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq.getBoolean(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, 1L);
        NewRegressionSeq.assertEquals((byte)1, (byte)seq.getByte(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, 2L);
        NewRegressionSeq.assertEquals((short)2, (short)seq.getShort(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, -1L);
        NewRegressionSeq.assertEquals((int)-1, (int)seq.getInt(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, -2L);
        NewRegressionSeq.assertEquals((long)-2L, (long)seq.getLong(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, "test 12 string");
        NewRegressionSeq.assertEquals((String)"test 12 string", (String)seq.getString(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq.getBoolean(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, 123.456f);
        NewRegressionSeq.assertEquals((double)123.456f, (double)seq.getFloat(5), (double)5.0E-5);
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, -123.456);
        NewRegressionSeq.assertEquals((double)-123.456, (double)seq.getDouble(5), (double)5.0E-9);
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, (RDFNode)tvLiteral);
        NewRegressionSeq.assertEquals((Object)tvLiteral, (Object)seq.getLiteral(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, (RDFNode)tvResource);
        NewRegressionSeq.assertEquals((Object)tvResource, (Object)seq.getResource(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, tvLitObj);
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
    }
}

