/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionSelector
extends ModelTestBase {
    protected Model m;

    public NewRegressionSelector(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionSelector.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
    }

    public void tearDown() {
        this.m = null;
    }

    public void test9() {
        int i;
        Model m = this.getModel();
        int num = 2;
        Resource[] subject = new Resource[2];
        Property[] predicate = new Property[2];
        String suri = "http://aldabaran/test9/s";
        String puri = "http://aldabaran/test9/";
        boolean[] tvBooleans = new boolean[]{false, true};
        long[] tvLongs = new long[]{123L, 321L};
        char[] tvChars = new char[]{'@', ';'};
        double[] tvDoubles = new double[]{123.456, 456.123};
        String[] tvStrings = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] langs = new String[]{"en", "fr"};
        for (i = 0; i < 2; ++i) {
            subject[i] = m.createResource(suri + i);
            predicate[i] = m.createProperty(puri + i, "p");
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                m.addLiteral(subject[i], predicate[j], tvBooleans[j]);
                m.addLiteral(subject[i], predicate[j], tvLongs[j]);
                m.addLiteral(subject[i], predicate[j], tvChars[j]);
                m.addLiteral(subject[i], predicate[j], tvDoubles[j]);
                m.add(subject[i], predicate[j], tvStrings[j]);
                m.add(subject[i], predicate[j], tvStrings[j], langs[j]);
            }
        }
        StmtIterator it1 = m.listStatements((Selector)new SimpleSelector(null, null, (RDFNode)null));
        List L1 = NewRegressionSelector.iteratorToList(it1);
        NewRegressionSelector.assertEquals((int)24, (int)L1.size());
        StmtIterator it2 = m.listStatements((Selector)new SimpleSelector(subject[0], null, (RDFNode)null));
        List L2 = NewRegressionSelector.iteratorToList(it2);
        for (int i2 = 0; i2 < L2.size(); ++i2) {
            NewRegressionSelector.assertEquals((Object)subject[0], (Object)((Statement)L2.get(i2)).getSubject());
        }
        NewRegressionSelector.assertEquals((int)12, (int)L2.size());
        StmtIterator it3 = m.listStatements((Selector)new SimpleSelector(null, predicate[1], (RDFNode)null));
        List L3 = NewRegressionSelector.iteratorToList(it3);
        for (int i3 = 0; i3 < L3.size(); ++i3) {
            NewRegressionSelector.assertEquals((Object)predicate[1], (Object)((Statement)L3.get(i3)).getPredicate());
        }
        NewRegressionSelector.assertEquals((int)12, (int)L3.size());
        StmtIterator it5 = m.listStatements((Selector)new SimpleSelector(null, null, (RDFNode)m.createTypedLiteral(false)));
        List L5 = NewRegressionSelector.iteratorToList(it5);
        for (int i4 = 0; i4 < L5.size(); ++i4) {
            NewRegressionSelector.assertEquals((boolean)false, (boolean)((Statement)L5.get(i4)).getBoolean());
        }
        NewRegressionSelector.assertEquals((int)2, (int)L5.size());
        StmtIterator it6 = m.listStatements((Selector)new SimpleSelector(null, null, tvStrings[1], langs[1]));
        List L6 = NewRegressionSelector.iteratorToList(it6);
        for (int i5 = 0; i5 < L6.size(); ++i5) {
            NewRegressionSelector.assertEquals((String)langs[1], (String)((Statement)L6.get(i5)).getLanguage());
        }
        NewRegressionSelector.assertEquals((int)2, (int)L6.size());
    }
}

