/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.regression.NewRegressionBase;
import com.hp.hpl.jena.vocabulary.RDF;

public abstract class NewRegressionContainerMethods
extends NewRegressionBase {
    protected Model m;
    protected Resource r;

    public NewRegressionContainerMethods(String name) {
        super(name);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
        this.r = this.m.createResource();
    }

    protected abstract Container createContainer();

    protected abstract Resource getContainerType();

    public void testEmptyContainer() {
        Container c = this.createContainer();
        NewRegressionContainerMethods.assertTrue((boolean)this.m.contains((Resource)c, RDF.type, (RDFNode)this.getContainerType()));
        NewRegressionContainerMethods.assertEquals((int)0, (int)c.size());
        NewRegressionContainerMethods.assertFalse((boolean)c.contains(true));
        NewRegressionContainerMethods.assertFalse((boolean)c.contains(1L));
        NewRegressionContainerMethods.assertFalse((boolean)c.contains(2L));
        NewRegressionContainerMethods.assertFalse((boolean)c.contains(-1L));
        NewRegressionContainerMethods.assertFalse((boolean)c.contains(-2L));
        NewRegressionContainerMethods.assertFalse((boolean)c.contains('!'));
        NewRegressionContainerMethods.assertFalse((boolean)c.contains(123.456f));
        NewRegressionContainerMethods.assertFalse((boolean)c.contains("test 12 string"));
    }

    public void testFillingContainer() {
        Container c = this.createContainer();
        String lang = "fr";
        Literal tvLiteral = this.m.createLiteral("test 12 string 2");
        c.add(true);
        NewRegressionContainerMethods.assertTrue((boolean)c.contains(true));
        c.add(1L);
        NewRegressionContainerMethods.assertTrue((boolean)c.contains(1L));
        c.add(2L);
        NewRegressionContainerMethods.assertTrue((boolean)c.contains(2L));
        c.add(-1L);
        NewRegressionContainerMethods.assertTrue((boolean)c.contains(-1L));
        c.add(-2L);
        NewRegressionContainerMethods.assertTrue((boolean)c.contains(-2L));
        c.add('!');
        NewRegressionContainerMethods.assertTrue((boolean)c.contains('!'));
        c.add(123.456f);
        NewRegressionContainerMethods.assertTrue((boolean)c.contains(123.456f));
        c.add("test 12 string");
        NewRegressionContainerMethods.assertTrue((boolean)c.contains("test 12 string"));
        c.add("test 12 string", lang);
        NewRegressionContainerMethods.assertTrue((boolean)c.contains("test 12 string", lang));
        c.add((RDFNode)tvLiteral);
        NewRegressionContainerMethods.assertTrue((boolean)c.contains((RDFNode)tvLiteral));
        c.add(tvLitObj);
        NewRegressionContainerMethods.assertTrue((boolean)c.contains(tvLitObj));
        NewRegressionContainerMethods.assertEquals((int)11, (int)c.size());
    }

    public void testContainerOfIntegers() {
        int num = 10;
        Container c = this.createContainer();
        for (int i = 0; i < num; ++i) {
            c.add((long)i);
        }
        NewRegressionContainerMethods.assertEquals((int)num, (int)c.size());
        NodeIterator it = c.iterator();
        for (int i = 0; i < num; ++i) {
            NewRegressionContainerMethods.assertEquals((int)i, (int)((Literal)it.nextNode()).getInt());
        }
        NewRegressionContainerMethods.assertFalse((boolean)it.hasNext());
    }

    public void testContainerOfIntegersRemovingA() {
        boolean[] retain = new boolean[]{true, true, true, false, false, false, false, false, true, true};
        this.testContainerOfIntegersWithRemoving(retain);
    }

    public void testContainerOfIntegersRemovingB() {
        boolean[] retain = new boolean[]{false, true, true, false, false, false, false, false, true, false};
        this.testContainerOfIntegersWithRemoving(retain);
    }

    public void testContainerOfIntegersRemovingC() {
        boolean[] retain = new boolean[]{false, false, false, false, false, false, false, false, false, false};
        this.testContainerOfIntegersWithRemoving(retain);
    }

    protected void testContainerOfIntegersWithRemoving(boolean[] retain) {
        int num = retain.length;
        boolean[] found = new boolean[num];
        Container c = this.createContainer();
        for (int i = 0; i < num; ++i) {
            c.add((long)i);
        }
        NodeIterator it = c.iterator();
        for (int i = 0; i < num; ++i) {
            it.nextNode();
            if (retain[i]) continue;
            it.remove();
        }
        NodeIterator s = c.iterator();
        while (s.hasNext()) {
            int v = ((Literal)s.nextNode()).getInt();
            NewRegressionContainerMethods.assertFalse((boolean)found[v]);
            found[v] = true;
        }
        for (int i = 0; i < num; ++i) {
            NewRegressionContainerMethods.assertEquals((String)("element " + i), (boolean)retain[i], (boolean)found[i]);
        }
    }
}

