/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.regression.NewRegressionContainerMethods;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionAltMethods
extends NewRegressionContainerMethods {
    public NewRegressionAltMethods(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionAltMethods.class);
    }

    protected Container createContainer() {
        return this.m.createAlt();
    }

    protected Resource getContainerType() {
        return RDF.Alt;
    }

    public void testDefaults() {
        Alt a = this.m.createAlt();
        Literal tvLiteral = this.m.createLiteral("test 12 string 2");
        Bag tvBag = this.m.createBag();
        Alt tvAlt = this.m.createAlt();
        Seq tvSeq = this.m.createSeq();
        Resource tvResource = this.m.createResource();
        NewRegressionAltMethods.assertEquals((Object)tvLiteral, (Object)a.setDefault((RDFNode)tvLiteral).getDefault());
        NewRegressionAltMethods.assertEquals((Object)tvLiteral, (Object)a.getDefaultLiteral());
        NewRegressionAltMethods.assertEquals((Object)tvResource, (Object)a.setDefault((RDFNode)tvResource).getDefaultResource());
        NewRegressionAltMethods.assertEquals((byte)1, (byte)a.setDefault(1L).getDefaultByte());
        NewRegressionAltMethods.assertEquals((short)2, (short)a.setDefault(2L).getDefaultShort());
        NewRegressionAltMethods.assertEquals((int)-1, (int)a.setDefault(-1L).getDefaultInt());
        NewRegressionAltMethods.assertEquals((long)-2L, (long)a.setDefault(-2L).getDefaultLong());
        NewRegressionAltMethods.assertEquals((float)123.456f, (float)a.setDefault(123.456f).getDefaultFloat(), (float)5.0E-6f);
        NewRegressionAltMethods.assertEquals((double)-123.456, (double)a.setDefault(-123.456).getDefaultDouble(), (double)5.0E-9);
        NewRegressionAltMethods.assertEquals((char)'!', (char)a.setDefault('!').getDefaultChar());
        NewRegressionAltMethods.assertEquals((String)"test 12 string", (String)a.setDefault("test 12 string").getDefaultString());
        NewRegressionAltMethods.assertEquals((Object)tvAlt, (Object)a.setDefault((RDFNode)tvAlt).getDefaultAlt());
        NewRegressionAltMethods.assertEquals((Object)tvBag, (Object)a.setDefault((RDFNode)tvBag).getDefaultBag());
        NewRegressionAltMethods.assertEquals((Object)tvSeq, (Object)a.setDefault((RDFNode)tvSeq).getDefaultSeq());
    }
}

