/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.math.BigInteger;

class HyperCube {
    private final Resource[] corners;
    private final int dim;
    private final Model model;
    private int id = 2000;

    public HyperCube(int dimension, Model m) {
        int i;
        this.dim = dimension;
        this.model = m;
        this.corners = new Resource[1 << this.dim];
        for (i = 0; i < this.corners.length; ++i) {
            this.corners[i] = m.createResource();
        }
        for (i = 0; i < this.corners.length; ++i) {
            this.add(i, this.corners[i]);
        }
    }

    private void add(int corner, Resource r) {
        for (int j = 0; j < this.dim; ++j) {
            int bit = 1 << j;
            this.model.add(r, RDF.value, (RDFNode)this.corners[corner ^ bit]);
        }
    }

    HyperCube dupe(int corner) {
        Resource dup = this.model.createResource();
        this.add(corner, dup);
        return this;
    }

    HyperCube toggle(int from, int to) {
        Resource f = this.corners[from];
        Resource t = this.corners[to];
        Statement s = this.model.createStatement(f, RDF.value, (RDFNode)t);
        if (this.model.contains(s)) {
            this.model.remove(s);
        } else {
            this.model.add(s);
        }
        return this;
    }

    static int bitCount(int i) {
        return BigInteger.valueOf(i).bitCount();
    }

    static boolean equal(int a1, int a2, int b1, int b2) {
        return HyperCube.bitCount(a1 ^ a2) == HyperCube.bitCount(b1 ^ b2);
    }
}

