/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.SafeGraph;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSafeModel
extends TestCase {
    public TestSafeModel(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestSafeModel.class);
    }

    public void testBasics() {
        Model base = ModelFactory.createDefaultModel();
        Resource r = base.createResource("urn:x-hp:eg/r");
        Property p = base.createProperty("urn:x-hp:eg/p");
        Property q = base.createProperty("urn:x-hp:eg/q");
        Literal l = base.createLiteral("foo");
        Statement asserted = base.createStatement(r, p, (RDFNode)l);
        r.addProperty(p, (RDFNode)l);
        List rules = Rule.parseRules((String)"(?r eg:p ?v) -> (?v eg:q ?r).");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        InfModel inf = ModelFactory.createInfModel((Reasoner)reasoner, (Model)base);
        TestUtil.assertIteratorValues(this, inf.listStatements(), new Statement[]{asserted});
        Model deductions = inf.getDeductionsModel();
        TestUtil.assertIteratorValues(this, deductions.listStatements(), new Statement[0]);
        Graph safeGraph = deductions.getGraph();
        TestSafeModel.assertTrue((boolean)(safeGraph instanceof SafeGraph));
        Graph rawGraph = ((SafeGraph)safeGraph).getRawGraph();
        Triple deduction = new Triple(l.asNode(), q.asNode(), r.asNode());
        TestUtil.assertIteratorValues(this, rawGraph.find(Node.ANY, Node.ANY, Node.ANY), new Triple[]{deduction});
    }
}

