/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.RDFSFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTestBase;
import com.hp.hpl.jena.reasoner.test.ReasonerTester;
import com.hp.hpl.jena.reasoner.test.TestReasoners;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRDFSReasoners
extends ReasonerTestBase {
    public static final String NAMESPACE = "http://www.hpl.hp.com/semweb/2003/query_tester/";
    protected static Logger logger = LoggerFactory.getLogger(TestReasoners.class);

    public TestRDFSReasoners(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        try {
            TestRDFSReasoners.constructQuerytests(suite, "rdfs/manifest-nodirect-noresource.rdf", RDFSFBRuleReasonerFactory.theInstance(), null);
            Resource config = TestRDFSReasoners.newResource().addProperty(ReasonerVocabulary.PROPenableCMPScan, "true");
            TestRDFSReasoners.constructRDFWGtests(suite, RDFSRuleReasonerFactory.theInstance(), null);
            TestRDFSReasoners.constructQuerytests(suite, "rdfs/manifest-standard.rdf", RDFSRuleReasonerFactory.theInstance(), config);
            suite.addTest((Test)new TestRDFSMisc(RDFSRuleReasonerFactory.theInstance(), null));
            Resource configFull = TestRDFSReasoners.newResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, "full");
            TestRDFSReasoners.constructQuerytests(suite, "rdfs/manifest.rdf", RDFSRuleReasonerFactory.theInstance(), configFull);
            Resource configSimple = TestRDFSReasoners.newResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, "simple");
            TestRDFSReasoners.constructQuerytests(suite, "rdfs/manifest-simple.rdf", RDFSRuleReasonerFactory.theInstance(), configSimple);
        }
        catch (IOException e) {
            logger.error("Failed to construct RDFS test harness", (Throwable)e);
        }
        return suite;
    }

    private static void constructSingleQuerytests(TestSuite suite, String manifest, String test, ReasonerFactory rf, Resource config) throws IOException {
        ReasonerTester tester = new ReasonerTester(manifest);
        Reasoner r = rf.create(config);
        suite.addTest((Test)new TestReasonerFromManifest(tester, test, r));
    }

    private static void constructQuerytests(TestSuite suite, String manifest, ReasonerFactory rf, Resource config) throws IOException {
        ReasonerTester tester = new ReasonerTester(manifest);
        Reasoner r = rf.create(config);
        for (String test : tester.listTests()) {
            suite.addTest((Test)new TestReasonerFromManifest(tester, test, r));
        }
    }

    private static void constructRDFWGtests(TestSuite suite, ReasonerFactory rf, Resource config) throws IOException {
        WGReasonerTester tester = new WGReasonerTester("Manifest.rdf");
        for (String test : tester.listTests()) {
            suite.addTest((Test)new TestReasonerWG(tester, test, rf, config));
        }
    }

    public static void constructQuerytests(TestSuite suite, String manifest, Reasoner reasoner) throws IOException {
        ReasonerTester tester = new ReasonerTester(manifest);
        for (String test : tester.listTests()) {
            suite.addTest((Test)new TestReasonerFromManifest(tester, test, reasoner));
        }
    }

    static class TestRDFSMisc
    extends TestCase {
        ReasonerFactory reasonerFactory;
        Resource config;

        TestRDFSMisc(ReasonerFactory reasonerFactory, Resource config) {
            super("TestRDFSMisc");
            this.reasonerFactory = reasonerFactory;
            this.config = config;
        }

        public void runTest() throws IOException {
            ReasonerTester tester = new ReasonerTester("rdfs/manifest.rdf");
            Resource configuration = ReasonerTestBase.newResource();
            if (this.config != null) {
                StmtIterator i = this.config.listProperties();
                while (i.hasNext()) {
                    Statement s = i.nextStatement();
                    configuration.addProperty(s.getPredicate(), s.getObject());
                }
            }
            configuration.addProperty(ReasonerVocabulary.PROPenableCMPScan, "false");
            TestRDFSMisc.assertTrue((String)"scanproperties off", (!tester.runTest("http://www.hpl.hp.com/semweb/2003/query_tester/rdfs/test17", this.reasonerFactory, null, configuration) ? (byte)1 : 0) != 0);
            Reasoner r = this.reasonerFactory.create(null);
            TestRDFSMisc.assertTrue((boolean)r.supportsProperty(RDFS.subClassOf));
            TestRDFSMisc.assertTrue((boolean)r.supportsProperty(RDFS.domain));
            TestRDFSMisc.assertTrue((boolean)r.supportsProperty(RDFS.range));
            TestRDFSMisc.assertTrue((!this.doTestRDFSDTRange("dttest1.nt", this.reasonerFactory) ? (byte)1 : 0) != 0);
            TestRDFSMisc.assertTrue((!this.doTestRDFSDTRange("dttest2.nt", this.reasonerFactory) ? (byte)1 : 0) != 0);
            TestRDFSMisc.assertTrue((boolean)this.doTestRDFSDTRange("dttest3.nt", this.reasonerFactory));
        }

        private boolean doTestRDFSDTRange(String file, ReasonerFactory rf) throws IOException {
            String langType = "RDF/XML";
            if (file.endsWith(".nt")) {
                langType = "N-TRIPLE";
            } else if (file.endsWith("n3")) {
                langType = "N3";
            }
            Model m = ModelFactory.createNonreifyingModel();
            BufferedReader reader = new BufferedReader(new FileReader("testing/reasoners/rdfs/" + file));
            m.read((Reader)reader, "http://www.w3.org/2000/10/rdf-tests/rdfcore/" + file, langType);
            InfGraph g = rf.create(null).bind(m.getGraph());
            ValidityReport report = g.validate();
            if (!report.isValid()) {
                logger.debug("Validation error report:");
                Iterator i = report.getReports();
                while (i.hasNext()) {
                    logger.debug(((ValidityReport.Report)i.next()).toString());
                }
            }
            return report.isValid();
        }
    }

    static class TestReasonerWG
    extends TestCase {
        WGReasonerTester tester;
        String test;
        ReasonerFactory reasonerFactory;
        Resource config;

        TestReasonerWG(WGReasonerTester tester, String test, ReasonerFactory reasonerFactory, Resource config) {
            super(test);
            this.tester = tester;
            this.test = test;
            this.reasonerFactory = reasonerFactory;
            this.config = config;
        }

        public void runTest() throws IOException {
            this.tester.runTest(this.test, this.reasonerFactory, this, this.config);
        }
    }

    static class TestReasonerFromManifest
    extends TestCase {
        ReasonerTester tester;
        String test;
        Reasoner reasoner;

        TestReasonerFromManifest(ReasonerTester tester, String test, Reasoner reasoner) {
            super(test);
            this.tester = tester;
            this.test = test;
            this.reasoner = reasoner;
        }

        public void runTest() throws IOException {
            this.tester.runTest(this.test, this.reasoner, this);
        }
    }
}

