/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestInfModel
extends TestCase {
    public TestInfModel(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestInfModel.class);
    }

    public void testListWithPosits() {
        String NS = "urn:x-hp:eg/";
        Model data = ModelFactory.createDefaultModel();
        Resource c1 = data.createResource(NS + "C1");
        Resource c2 = data.createResource(NS + "C2");
        Resource c3 = data.createResource(NS + "C3");
        data.add(c2, RDFS.subClassOf, (RDFNode)c3);
        Model premise = ModelFactory.createDefaultModel();
        premise.add(c1, RDFS.subClassOf, (RDFNode)c2);
        InfModel im = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getRDFSReasoner(), (Model)data);
        TestUtil.assertIteratorValues(this, im.listStatements(c1, RDFS.subClassOf, null, premise), new Object[]{data.createStatement(c1, RDFS.subClassOf, (RDFNode)c2), data.createStatement(c1, RDFS.subClassOf, (RDFNode)c3), data.createStatement(c1, RDFS.subClassOf, (RDFNode)c1)});
        OntModel om = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM_RDFS_INF, (Model)data);
        TestUtil.assertIteratorValues(this, om.listStatements(c1, RDFS.subClassOf, null, premise), new Object[]{data.createStatement(c1, RDFS.subClassOf, (RDFNode)c2), data.createStatement(c1, RDFS.subClassOf, (RDFNode)c3), data.createStatement(c1, RDFS.subClassOf, (RDFNode)c1)});
    }
}

