/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTester;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRDFSRules
extends TestCase {
    public static final String NAMESPACE = "http://www.hpl.hp.com/semweb/2003/query_tester/";
    protected static Logger logger = LoggerFactory.getLogger(TestRDFSRules.class);

    public TestRDFSRules(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRDFSRules.class);
    }

    public void hiddenTestRDFSReasonerDebug() throws IOException {
        ReasonerTester tester = new ReasonerTester("rdfs/manifest-nodirect-noresource.rdf");
        ReasonerFactory rf = RDFSRuleReasonerFactory.theInstance();
        TestRDFSRules.assertTrue((String)"RDFS hybrid-tgc reasoner test", (boolean)tester.runTest("http://www.hpl.hp.com/semweb/2003/query_tester/rdfs/test11", rf, this, null));
    }

    public void testRDFSFBReasoner() throws IOException {
        ReasonerTester tester = new ReasonerTester("rdfs/manifest-nodirect-noresource.rdf");
        ReasonerFactory rf = RDFSFBRuleReasonerFactory.theInstance();
        TestRDFSRules.assertTrue((String)"RDFS hybrid reasoner tests", (boolean)tester.runTests(rf, this, null));
    }

    public void testRDFSExptReasoner() throws IOException {
        ReasonerTester tester = new ReasonerTester("rdfs/manifest-nodirect-noresource.rdf");
        ReasonerFactory rf = RDFSRuleReasonerFactory.theInstance();
        TestRDFSRules.assertTrue((String)"RDFS experimental (hybrid+tgc) reasoner tests", (boolean)tester.runTests(rf, this, null));
    }

    public void testRDFSDescription() {
        ReasonerFactory rf = RDFSFBRuleReasonerFactory.theInstance();
        Reasoner r = rf.create(null);
        TestRDFSRules.assertTrue((boolean)r.supportsProperty(RDFS.subClassOf));
        TestRDFSRules.assertTrue((boolean)r.supportsProperty(RDFS.domain));
        TestRDFSRules.assertTrue((!r.supportsProperty(OWL.allValuesFrom) ? (byte)1 : 0) != 0);
    }

    private static void doTiming(Reasoner r, Model tbox, Model data, String name, int loop) {
        Resource C1 = ResourceFactory.createResource((String)"http://www.hpl.hp.com/semweb/2003/eg#C1");
        Resource C2 = ResourceFactory.createResource((String)"http://www.hpl.hp.com/semweb/2003/eg#C2");
        long t1 = System.currentTimeMillis();
        int count = 0;
        for (int lp = 0; lp < loop; ++lp) {
            Model m = ModelFactory.createModelForGraph((Graph)r.bindSchema(tbox.getGraph()).bind(data.getGraph()));
            count = 0;
            StmtIterator i = m.listStatements(null, RDF.type, (RDFNode)C1);
            while (i.hasNext()) {
                ++count;
                i.next();
            }
        }
        long t2 = System.currentTimeMillis();
        long time10 = (t2 - t1) * 10L / (long)loop;
        long time = time10 / 10L;
        long timeFraction = time10 - time * 10L;
        System.out.println(name + ": " + count + " results in " + time + "." + timeFraction + "ms");
    }
}

