/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.reasoner.rulesys.test.ConcurrencyTest;
import com.hp.hpl.jena.reasoner.rulesys.test.OWLUnitTest;
import com.hp.hpl.jena.reasoner.rulesys.test.TestBackchainer;
import com.hp.hpl.jena.reasoner.rulesys.test.TestBasicLP;
import com.hp.hpl.jena.reasoner.rulesys.test.TestBasics;
import com.hp.hpl.jena.reasoner.rulesys.test.TestBugs;
import com.hp.hpl.jena.reasoner.rulesys.test.TestCapabilities;
import com.hp.hpl.jena.reasoner.rulesys.test.TestConfigVocabulary;
import com.hp.hpl.jena.reasoner.rulesys.test.TestFBRules;
import com.hp.hpl.jena.reasoner.rulesys.test.TestGenericRuleReasonerConfig;
import com.hp.hpl.jena.reasoner.rulesys.test.TestGenericRules;
import com.hp.hpl.jena.reasoner.rulesys.test.TestInferenceReification;
import com.hp.hpl.jena.reasoner.rulesys.test.TestLPDerivation;
import com.hp.hpl.jena.reasoner.rulesys.test.TestOWLMisc;
import com.hp.hpl.jena.reasoner.rulesys.test.TestRETE;
import com.hp.hpl.jena.reasoner.rulesys.test.TestRestrictionsDontNeedTyping;
import com.hp.hpl.jena.reasoner.rulesys.test.TestSetRules;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPackage
extends TestSuite {
    protected static Logger logger = LoggerFactory.getLogger(TestPackage.class);

    public static TestSuite suite() {
        return new TestPackage();
    }

    private TestPackage() {
        super("RuleSys");
        this.addTestSuite(TestConfigVocabulary.class);
        this.addTestSuite(TestGenericRuleReasonerConfig.class);
        this.addTest("TestBasics", TestBasics.suite());
        this.addTest("TestBackchainer", TestBackchainer.suite());
        this.addTest("TestLPBasics", TestBasicLP.suite());
        this.addTest("TestLPDerivation", TestLPDerivation.suite());
        this.addTest("TestFBRules", TestFBRules.suite());
        this.addTest("TestGenericRules", TestGenericRules.suite());
        this.addTest("TestRETE", TestRETE.suite());
        this.addTest((Test)TestSetRules.suite());
        this.addTest("OWLRuleUnitTests", OWLUnitTest.suite());
        this.addTest("TestBugs", TestBugs.suite());
        this.addTest("TestOWLMisc", TestOWLMisc.suite());
        this.addTest("TestCapabilities", TestCapabilities.suite());
        try {
            this.addTest("ConcurrentyTest", ConcurrencyTest.suite());
        }
        catch (Throwable t) {
            logger.warn("Skipping concurrency test, JVM doesn't seem to support fileDeadlockedThreads");
        }
        this.addTestSuite(TestInferenceReification.class);
        this.addTestSuite(TestRestrictionsDontNeedTyping.class);
    }

    private void addTest(String name, TestSuite tc) {
        tc.setName(name);
        this.addTest((Test)tc);
    }
}

