/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLWGTester {
    public static String BASE_URI = "http://www.w3.org/2002/03owlt/";
    public static String baseDir = "testing/wg/";
    public static final String NS_OTEST = "http://www.w3.org/2002/03owlt/testOntology#";
    public static final String NS_RTEST = "http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#";
    public static final Resource PositiveEntailmentTest;
    public static final Resource NegativeEntailmentTest;
    public static final Property descriptionP;
    public static final Property premiseDocumentP;
    public static final Property conclusionDocumentP;
    public static final Property statusP;
    protected ReasonerFactory reasonerF;
    protected Resource configuration;
    protected TestCase testcase;
    protected static long timeCost;
    protected static int numTests;
    protected static Logger logger;

    public OWLWGTester(ReasonerFactory reasonerF, TestCase testcase, Resource configuration) {
        this.reasonerF = reasonerF;
        this.testcase = testcase;
        this.configuration = configuration;
    }

    public boolean runTests(String manifestFile, boolean log, boolean stats) throws IOException {
        Resource test;
        Model manifest = FileManager.get().loadModel(baseDir + manifestFile);
        ResIterator tests = manifest.listResourcesWithProperty(RDF.type, (RDFNode)PositiveEntailmentTest);
        while (tests.hasNext()) {
            test = tests.nextResource();
            if (this.runTest(test, log, stats)) continue;
            return false;
        }
        tests = manifest.listResourcesWithProperty(RDF.type, (RDFNode)NegativeEntailmentTest);
        while (tests.hasNext()) {
            test = tests.nextResource();
            if (this.runTest(test, log, stats)) continue;
            return false;
        }
        return true;
    }

    public boolean runTest(Resource test, boolean log, boolean stats) throws IOException {
        RDFNode testType = test.getRequiredProperty(RDF.type).getObject();
        if (!testType.equals(NegativeEntailmentTest) && !testType.equals(PositiveEntailmentTest)) {
            throw new JenaException("Can't find test: " + test);
        }
        String description = test.getRequiredProperty(descriptionP).getObject().toString();
        String status = test.getRequiredProperty(statusP).getObject().toString();
        logger.debug("WG test " + test.getURI() + " - " + status);
        Model premises = ModelFactory.createNonreifyingModel();
        StmtIterator premisesI = test.listProperties(premiseDocumentP);
        while (premisesI.hasNext()) {
            premises.add(OWLWGTester.loadFile(premisesI.nextStatement().getObject().toString() + ".rdf"));
        }
        Resource conclusionsRes = (Resource)test.getRequiredProperty(conclusionDocumentP).getObject();
        Model conclusions = OWLWGTester.loadFile(conclusionsRes.toString() + ".rdf");
        if (log) {
            if (this.configuration == null) {
                Model m = ModelFactory.createDefaultModel();
                this.configuration = m.createResource();
            }
            this.configuration.addProperty(ReasonerVocabulary.PROPtraceOn, "true").addProperty(ReasonerVocabulary.PROPderivationLogging, "true");
        }
        Reasoner reasoner = this.reasonerF.create(this.configuration);
        long t1 = System.currentTimeMillis();
        InfGraph graph = reasoner.bind(premises.getGraph());
        Model result = ModelFactory.createModelForGraph((Graph)graph);
        if (!stats || graph instanceof FBRuleInfGraph) {
            // empty if block
        }
        boolean correct = true;
        correct = testType.equals(PositiveEntailmentTest) ? this.testConclusions(conclusions.getGraph(), result.getGraph()) : !this.testConclusions(conclusions.getGraph(), result.getGraph());
        long t2 = System.currentTimeMillis();
        timeCost += t2 - t1;
        ++numTests;
        if (stats) {
            logger.info("Time=" + (t2 - t1) + "ms for " + test.getURI());
            this.printStats();
            if (graph instanceof FBRuleInfGraph) {
                ((FBRuleInfGraph)graph).printLPProfile();
            }
        }
        if (!correct) {
            // empty if block
        }
        if (this.testcase != null) {
            Assert.assertTrue((String)("Test: " + test + "\n" + this.reasonerF.getURI() + "\n" + description), (boolean)correct);
        }
        return correct;
    }

    public static Model loadFile(String file) throws IOException {
        String langType = "RDF/XML";
        if (file.endsWith(".nt")) {
            langType = "N-TRIPLE";
        } else if (file.endsWith("n3")) {
            langType = "N3";
        }
        Model result = ModelFactory.createNonreifyingModel();
        String fname = file;
        if (fname.startsWith(BASE_URI)) {
            fname = fname.substring(BASE_URI.length());
        }
        BufferedReader reader = new BufferedReader(new FileReader(baseDir + fname));
        result.read((Reader)reader, BASE_URI + fname, langType);
        return result;
    }

    private boolean testConclusions(Graph conclusions, Graph result) {
        QueryHandler qh = result.queryHandler();
        Query query = WGReasonerTester.graphToQuery(conclusions);
        ExtendedIterator i = qh.prepareBindings(query, new Node[0]).executeBindings();
        return i.hasNext();
    }

    public void printStats() {
        logger.info("Ran " + numTests + " in " + timeCost + "ms = " + timeCost / (long)numTests + "ms/test");
    }

    static {
        timeCost = 0L;
        numTests = 0;
        logger = LoggerFactory.getLogger(OWLWGTester.class);
        PositiveEntailmentTest = ResourceFactory.createProperty((String)NS_OTEST, (String)"PositiveEntailmentTest");
        NegativeEntailmentTest = ResourceFactory.createProperty((String)NS_OTEST, (String)"NegativeEntailmentTest");
        descriptionP = ResourceFactory.createProperty((String)NS_RTEST, (String)"description");
        premiseDocumentP = ResourceFactory.createProperty((String)NS_RTEST, (String)"premiseDocument");
        conclusionDocumentP = ResourceFactory.createProperty((String)NS_RTEST, (String)"conclusionDocument");
        statusP = ResourceFactory.createProperty((String)NS_RTEST, (String)"status");
    }
}

