/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestResourceImpl
extends ModelTestBase {
    public TestResourceImpl(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestResourceImpl.class);
    }

    public void testCannotAsNonLiteral() {
        Model m = ModelFactory.createDefaultModel();
        TestResourceImpl.resource(m, "plumPie").as(Resource.class);
    }

    public void testAsLiteral() {
        Model m = ModelFactory.createDefaultModel();
        try {
            TestResourceImpl.literal(m, "17").as(Resource.class);
            TestResourceImpl.fail((String)"literals cannot be resources");
        }
        catch (ResourceRequiredException e) {
            TestResourceImpl.pass();
        }
    }

    public void testNameSpace() {
        TestResourceImpl.assertEquals((String)"eh:", (String)TestResourceImpl.resource("eh:xyz").getNameSpace());
        TestResourceImpl.assertEquals((String)"http://d/", (String)TestResourceImpl.resource("http://d/stuff").getNameSpace());
        TestResourceImpl.assertEquals((String)"ftp://dd.com/12345", (String)TestResourceImpl.resource("ftp://dd.com/12345").getNameSpace());
        TestResourceImpl.assertEquals((String)"http://domain/spoo#", (String)TestResourceImpl.resource("http://domain/spoo#anchor").getNameSpace());
        TestResourceImpl.assertEquals((String)"ftp://abd/def#ghi#", (String)TestResourceImpl.resource("ftp://abd/def#ghi#e11-2").getNameSpace());
    }

    public void testGetModel() {
        Model m = ModelFactory.createDefaultModel();
        TestResourceImpl.assertSame((Object)m, (Object)m.createResource("eh:/wossname").getModel());
    }

    public void testGetLocalNameReturnsLocalName() {
        TestResourceImpl.assertEquals((String)"xyz", (String)TestResourceImpl.resource("eh:xyz").getLocalName());
    }

    public void testHasURI() {
        TestResourceImpl.assertTrue((boolean)TestResourceImpl.resource("eh:xyz").hasURI("eh:xyz"));
        TestResourceImpl.assertFalse((boolean)TestResourceImpl.resource("eh:xyz").hasURI("eh:1yz"));
        TestResourceImpl.assertFalse((boolean)ResourceFactory.createResource().hasURI("42"));
    }

    public void testAddTypedPropertyDouble() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1.0);
        TestResourceImpl.assertEquals((Object)m.createTypedLiteral(1.0), (Object)r.getProperty(RDF.value).getLiteral());
    }

    public void testAddTypedPropertyFloat() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1.0f);
        TestResourceImpl.assertEquals((Object)m.createTypedLiteral(1.0f), (Object)r.getProperty(RDF.value).getLiteral());
    }

    public void testHasTypedPropertyDouble() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1.0);
        TestResourceImpl.assertTrue((boolean)r.hasLiteral(RDF.value, 1.0));
    }

    public void testHasTypedPropertyFloat() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1.0f);
        TestResourceImpl.assertTrue((boolean)r.hasLiteral(RDF.value, 1.0f));
    }

    public void testAddTypedPropertyLong() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1L);
        TestResourceImpl.assertEquals((Object)m.createTypedLiteral(1L), (Object)r.getProperty(RDF.value).getLiteral());
    }

    public void testHasTypedPropertyLong() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1L);
        TestResourceImpl.assertTrue((boolean)r.hasLiteral(RDF.value, 1L));
    }

    public void testAddTypedPropertyInt() {
    }

    public void testHasTypedPropertyInt() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1L);
        TestResourceImpl.assertTrue((boolean)r.hasLiteral(RDF.value, 1L));
    }

    public void testAddTypedPropertyChar() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 'x');
        TestResourceImpl.assertEquals((Object)m.createTypedLiteral('x'), (Object)r.getProperty(RDF.value).getLiteral());
    }

    public void testHasTypedPropertyChar() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 'x');
        TestResourceImpl.assertTrue((boolean)r.hasLiteral(RDF.value, 'x'));
    }

    public void testAddTypedPropertyBoolean() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, true);
        TestResourceImpl.assertEquals((Object)m.createTypedLiteral(true), (Object)r.getProperty(RDF.value).getLiteral());
    }

    public void testHasTypedPropertyBoolean() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, false);
        TestResourceImpl.assertTrue((boolean)r.hasLiteral(RDF.value, false));
    }

    public void testAddTypedPropertyString() {
    }

    public void testHasTypedPropertyString() {
    }

    public void testAddTypedPropertyObject() {
        Object z = new Object();
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, z);
        TestResourceImpl.assertEquals((Object)m.createTypedLiteral(z), (Object)r.getProperty(RDF.value).getLiteral());
    }

    public void testAddLiteralPassesLiteralUnmodified() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        Literal lit = m.createLiteral("spoo");
        r.addLiteral(RDF.value, lit);
        TestResourceImpl.assertTrue((String)"model should contain unmodified literal", (boolean)m.contains(null, RDF.value, (RDFNode)lit));
    }

    public void testHasTypedPropertyObject() {
        Object z = new Object();
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, z);
        TestResourceImpl.assertTrue((boolean)r.hasLiteral(RDF.value, z));
    }

    public void testGetPropertyResourceValueReturnsResource() {
        Model m = TestResourceImpl.modelWithStatements("x p 17; x p y");
        Resource r = m.createResource("eh:/x");
        Resource value = r.getPropertyResourceValue(TestResourceImpl.property("p"));
        TestResourceImpl.assertEquals((Object)TestResourceImpl.resource("y"), (Object)value);
    }

    public void testGetPropertyResourceValueReturnsNull() {
        Model m = TestResourceImpl.modelWithStatements("x p 17");
        Resource r = m.createResource("eh:/x");
        TestResourceImpl.assertNull((Object)r.getPropertyResourceValue(TestResourceImpl.property("q")));
        TestResourceImpl.assertNull((Object)r.getPropertyResourceValue(TestResourceImpl.property("p")));
    }
}

