/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestModelMakerImpl
extends ModelTestBase {
    private ModelMaker maker;
    private Graph graph;
    private GraphMaker graphMaker;

    public TestModelMakerImpl(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelMakerImpl.class);
    }

    public void setUp() {
        this.graph = GraphTestBase.graphWith("");
        this.graphMaker = new MockGraphMaker(this.graph);
        this.maker = new ModelMakerImpl(this.graphMaker);
    }

    public void testClose() {
        this.maker.close();
        this.checkHistory(TestModelMakerImpl.listOfOne("close()"));
    }

    public void testRemove() {
        this.maker.removeModel("London");
        this.checkHistory(TestModelMakerImpl.listOfOne("remove(London)"));
    }

    public void testCreateFreshModel() {
        this.maker.createFreshModel();
        this.checkHistory(TestModelMakerImpl.listOfOne("create()"));
    }

    public void testCreateDefaultModel() {
        this.maker.createDefaultModel();
        this.checkHistory(TestModelMakerImpl.listOfOne("get()"));
    }

    public void testCreateNamed() {
        Model m = this.maker.createModel("petal");
        this.checkHistory(TestModelMakerImpl.listOfOne("create(petal,false)"));
        TestModelMakerImpl.assertTrue((m.getGraph() == this.graph ? (byte)1 : 0) != 0);
    }

    public void testCreateTrue() {
        Model m = this.maker.createModel("stem", true);
        this.checkHistory(TestModelMakerImpl.listOfOne("create(stem,true)"));
        TestModelMakerImpl.assertTrue((m.getGraph() == this.graph ? (byte)1 : 0) != 0);
    }

    public void testCreateFalse() {
        Model m = this.maker.createModel("leaf", false);
        this.checkHistory(TestModelMakerImpl.listOfOne("create(leaf,false)"));
        TestModelMakerImpl.assertTrue((m.getGraph() == this.graph ? (byte)1 : 0) != 0);
    }

    public void testOpen() {
        Model m = this.maker.openModel("trunk");
        this.checkHistory(TestModelMakerImpl.listOfOne("open(trunk,false)"));
        TestModelMakerImpl.assertTrue((m.getGraph() == this.graph ? (byte)1 : 0) != 0);
    }

    public void testOpenFalse() {
        Model m = this.maker.openModel("branch", false);
        this.checkHistory(TestModelMakerImpl.listOfOne("open(branch,false)"));
        TestModelMakerImpl.assertTrue((m.getGraph() == this.graph ? (byte)1 : 0) != 0);
    }

    public void testOpenTrue() {
        Model m = this.maker.openModel("bark", true);
        this.checkHistory(TestModelMakerImpl.listOfOne("open(bark,true)"));
        TestModelMakerImpl.assertTrue((m.getGraph() == this.graph ? (byte)1 : 0) != 0);
    }

    public void testListGraphs() {
        this.maker.listModels().close();
        this.checkHistory(TestModelMakerImpl.listOfOne("listModels()"));
    }

    public void testGetGraphMaker() {
        TestModelMakerImpl.assertTrue((this.maker.getGraphMaker() == this.graphMaker ? (byte)1 : 0) != 0);
    }

    private void checkHistory(List<String> expected) {
        TestModelMakerImpl.assertEquals(expected, this.history());
    }

    private List<String> history() {
        return ((MockGraphMaker)this.maker.getGraphMaker()).history;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MockGraphMaker
    implements GraphMaker {
        List<String> history = new ArrayList<String>();
        Graph graph;

        public MockGraphMaker(Graph graph) {
            this.graph = graph;
        }

        public ReificationStyle getReificationStyle() {
            this.history.add("getReificationStyle()");
            return null;
        }

        public Graph getGraph() {
            this.history.add("get()");
            return this.graph;
        }

        public Graph createGraph() {
            this.history.add("create()");
            return this.graph;
        }

        public Graph createGraph(String name, boolean strict) {
            this.history.add("create(" + name + "," + strict + ")");
            return this.graph;
        }

        public Graph createGraph(String name) {
            this.history.add("create(" + name + ")");
            return this.graph;
        }

        public Graph openGraph(String name, boolean strict) {
            this.history.add("open(" + name + "," + strict + ")");
            return this.graph;
        }

        public Graph openGraph(String name) {
            this.history.add("open(" + name + ")");
            return this.graph;
        }

        public void removeGraph(String name) {
            this.history.add("remove(" + name + ")");
        }

        public boolean hasGraph(String name) {
            this.history.add("has(" + name + ")");
            return false;
        }

        public Graph getDescription() {
            this.history.add("getDescription()");
            return GraphTestBase.graphWith("");
        }

        public Graph getDescription(Node root) {
            this.history.add("getDescription(Node)");
            return GraphTestBase.graphWith("");
        }

        public Graph addDescription(Graph desc, Node self) {
            this.history.add("addDescription()");
            return desc;
        }

        public void close() {
            this.history.add("close()");
        }

        public ExtendedIterator<String> listGraphs() {
            this.history.add("listModels()");
            return NullIterator.instance();
        }

        public Graph openGraph() {
            return null;
        }
    }
}

