/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.states;

import com.hp.hpl.jena.rdf.arp.states.EventRecord;

class FullEventRecord
extends EventRecord {
    String state;
    EventRecord[] moreCharacter;
    String[] fields;
    int ix;

    FullEventRecord(String[] fields) {
        this.fields = fields;
        this.state = fields[0];
        this.ix = 1;
        this.startEvents = this.upto("$");
        this.rsltState = fields[this.ix++];
        this.rsltCharacter = this.upto("{");
        this.moreCharacter = new EventRecord[this.count(";")];
        for (int i = 0; i < this.moreCharacter.length; ++i) {
            this.moreCharacter[i] = new EventRecord();
            this.moreCharacter[i].startEvents = this.upto("$");
            this.moreCharacter[i].rsltState = fields[this.ix++];
            this.moreCharacter[i].rsltCharacter = this.upto(";");
            this.moreCharacter[i].checkStar(this.state);
        }
        this.checkStar(this.state);
    }

    public String toString() {
        StringBuffer rslt = new StringBuffer("|" + this.state + "| " + super.toString());
        rslt.append("{ ");
        for (int i = 0; i < this.moreCharacter.length; ++i) {
            rslt.append(this.moreCharacter[i].toString() + " ; ");
        }
        rslt.append(" }");
        return rslt.toString();
    }

    private int count(String sep) {
        int rslt = 0;
        int i = 0;
        while (i + this.ix < this.fields.length) {
            if (sep.equals(this.fields[i + this.ix])) {
                ++rslt;
            }
            ++i;
        }
        return rslt;
    }

    private String[] upto(String sep) {
        String[] rslt = new String[this.dist(sep)];
        System.arraycopy(this.fields, this.ix, rslt, 0, rslt.length);
        this.ix += rslt.length + 1;
        return rslt;
    }

    private int dist(String sep) {
        if (this.ix >= this.fields.length) {
            return 0;
        }
        int rslt = 0;
        while (!sep.equals(this.fields[this.ix + rslt])) {
            if (rslt + this.ix == this.fields.length - 1) {
                return 0;
            }
            ++rslt;
        }
        return rslt;
    }
}

