/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.mem.test.AbstractTestGraphMem;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import junit.framework.TestSuite;

public class TestGraphMem
extends AbstractTestGraphMem {
    public TestGraphMem(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestGraphMem.class);
    }

    public Graph getGraph() {
        return Factory.createGraphMem();
    }

    public void testRemoveAllDoesntUseFind() {
        GraphMemWithoutFind g = new GraphMemWithoutFind();
        TestGraphMem.graphAdd((Graph)g, "x P y; a Q b");
        g.getBulkUpdateHandler().removeAll();
        TestGraphMem.assertEquals((int)0, (int)g.size());
    }

    public void testSizeAfterRemove() {
        Graph g = this.getGraphWith("x p y");
        ExtendedIterator it = g.find((TripleMatch)TestGraphMem.triple("x ?? ??"));
        it.removeNext();
        TestGraphMem.assertEquals((int)0, (int)g.size());
    }

    public void testContainsConcreteDoesntUseFind() {
        GraphMemWithoutFind g = new GraphMemWithoutFind();
        TestGraphMem.graphAdd((Graph)g, "x P y; a Q b");
        TestGraphMem.assertTrue((boolean)g.contains(TestGraphMem.triple("x P y")));
        TestGraphMem.assertTrue((boolean)g.contains(TestGraphMem.triple("a Q b")));
        TestGraphMem.assertFalse((boolean)g.contains(TestGraphMem.triple("a P y")));
        TestGraphMem.assertFalse((boolean)g.contains(TestGraphMem.triple("y R b")));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class GraphMemWithoutFind
    extends GraphMem {
        protected GraphMemWithoutFind() {
        }

        public ExtendedIterator<Triple> graphBaseFind(TripleMatch t) {
            throw new JenaException("find is Not Allowed");
        }
    }
}

