/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;

public class TestRegisterGraphListener
extends GraphTestBase {
    private ComeAndGoListener[] all;
    private Graph graph;

    public TestRegisterGraphListener(String name) {
        super(name);
    }

    private void testAddingTriple(int addMe, ComeAndGoListener ... allx) {
        this.graph = TestRegisterGraphListener.newGraph();
        this.all = allx;
        for (int i = 0; i < addMe; ++i) {
            this.all[i].registerWith(this.graph);
        }
        for (ComeAndGoListener l : this.all) {
            l.start();
        }
        this.graph.add(TestRegisterGraphListener.triple("make a change"));
        for (ComeAndGoListener l : this.all) {
            l.check();
        }
    }

    public void testAddOne() {
        this.testAddingTriple(2, new ComeAndGoListener(){

            void doSomeDamage() {
                TestRegisterGraphListener.this.all[2].registerWith(TestRegisterGraphListener.this.graph);
            }
        }, new SimpleListener(), new SimpleListener());
    }

    public void testDelete2nd() {
        this.testAddingTriple(3, new ComeAndGoListener(){

            void doSomeDamage() {
                TestRegisterGraphListener.this.all[1].unregisterFrom(TestRegisterGraphListener.this.graph);
            }
        }, new SimpleListener(), new SimpleListener());
    }

    public void testDelete1st() {
        this.testAddingTriple(3, new SimpleListener(), new ComeAndGoListener(){

            void doSomeDamage() {
                TestRegisterGraphListener.this.all[0].unregisterFrom(TestRegisterGraphListener.this.graph);
            }
        }, new SimpleListener());
    }

    public void testDeleteSelf() {
        this.testAddingTriple(3, new ComeAndGoListener(){

            void doSomeDamage() {
                this.unregisterFrom(TestRegisterGraphListener.this.graph);
            }
        }, new SimpleListener(), new SimpleListener());
    }

    public void testDeleteAndAddSelf() {
        this.testAddingTriple(3, new ComeAndGoListener(){

            void doSomeDamage() {
                this.unregisterFrom(TestRegisterGraphListener.this.graph);
                this.registerWith(TestRegisterGraphListener.this.graph);
            }
        }, new SimpleListener(), new SimpleListener());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ComeAndGoListener
    implements GraphListener {
        boolean inPlay = false;
        boolean registered = false;
        boolean notified = false;

        private ComeAndGoListener() {
        }

        void registerWith(Graph g) {
            this.registered = true;
            g.getEventManager().register((GraphListener)this);
        }

        void unregisterFrom(Graph g) {
            this.registered = false;
            this.inPlay = false;
            g.getEventManager().unregister((GraphListener)this);
        }

        void start() {
            if (this.registered) {
                this.inPlay = true;
            }
        }

        void check() {
            if (this.inPlay && !this.notified) {
                Assert.fail((String)"listener that was in-play was not notified of adding triple.");
            }
        }

        public final void notifyAddTriple(Graph g, Triple t) {
            this.notified = true;
            this.doSomeDamage();
        }

        abstract void doSomeDamage();

        public void notifyAddArray(Graph g, Triple[] triples) {
        }

        public void notifyAddGraph(Graph g, Graph added) {
        }

        public void notifyAddIterator(Graph g, Iterator<Triple> it) {
        }

        public void notifyAddList(Graph g, List<Triple> triples) {
        }

        public void notifyDeleteArray(Graph g, Triple[] triples) {
        }

        public void notifyDeleteGraph(Graph g, Graph removed) {
        }

        public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
        }

        public void notifyDeleteList(Graph g, List<Triple> L) {
        }

        public void notifyDeleteTriple(Graph g, Triple t) {
        }

        public void notifyEvent(Graph source, Object value) {
        }
    }

    private static final class SimpleListener
    extends ComeAndGoListener {
        private SimpleListener() {
        }

        void doSomeDamage() {
        }
    }
}

