/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;

public class TestGraphEvents
extends GraphTestBase {
    public TestGraphEvents(String name) {
        super(name);
    }

    public void testGraphEventContent() {
        this.testGraphEventContents("testing", "an example");
        this.testGraphEventContents("toasting", Boolean.TRUE);
        this.testGraphEventContents("tasting", NodeCreateUtils.createTriple("we are here"));
    }

    public void testGraphEventsRemove() {
        this.testGraphEventsRemove("s", "p", "o");
        this.testGraphEventsRemove("s", "p", "17");
        this.testGraphEventsRemove("_s", "p", "'object'");
        this.testGraphEventsRemove("not:known", "p", "'chat'fr");
    }

    private void testGraphEventsRemove(String S, String P, String O) {
        Triple expected = NodeCreateUtils.createTriple(S + " " + P + " " + O);
        GraphEvents e = GraphEvents.remove((Node)TestGraphEvents.node(S), (Node)TestGraphEvents.node(P), (Node)TestGraphEvents.node(O));
        TestGraphEvents.assertEquals((Object)expected, (Object)e.getContent());
        TestGraphEvents.assertEquals((Object)"remove", (Object)e.getTitle());
    }

    private void testGraphEventContents(String title, Object expected) {
        GraphEvents e = new GraphEvents(title, expected);
        TestGraphEvents.assertEquals((Object)title, (Object)e.getTitle());
        TestGraphEvents.assertEquals((Object)expected, (Object)e.getContent());
    }
}

