/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashSet;
import java.util.Set;

public class TestGraphBaseToString
extends GraphTestBase {
    public TestGraphBaseToString(String name) {
        super(name);
    }

    public void testToStringBaseAndLimit() {
        TestGraphBaseToString.assertTrue((String)"triple base count must be greater than 0", (boolean)true);
        TestGraphBaseToString.assertTrue((String)"triple base count must be less than limit", (boolean)true);
        TestGraphBaseToString.assertTrue((String)"triple count limit must be less than 20", (boolean)true);
    }

    public void testEllipsisAbsentForSmallModels() {
        LittleGraphBase g = new LittleGraphBase();
        this.addTriples((Graph)g, 1, 10);
        TestGraphBaseToString.assertFalse((String)"small model must not contain ellipsis cut-off", (boolean)((Object)((Object)g)).toString().contains("\\.\\.\\."));
    }

    public void testEllipsisPresentForLargeModels() {
        LittleGraphBase g = new LittleGraphBase();
        this.addTriples((Graph)g, 1, 18);
        TestGraphBaseToString.assertFalse((String)"large model must contain ellipsis cut-off", (boolean)((Object)((Object)g)).toString().contains("\\.\\.\\."));
    }

    public void testStringTripleCount() {
        LittleGraphBase g = new LittleGraphBase();
        int baseCount = 10;
        this.addTriples((Graph)g, 1, baseCount);
        TestGraphBaseToString.assertEquals((int)baseCount, (int)this.countTriples(((Object)((Object)g)).toString()));
        this.addTriples((Graph)g, baseCount + 1, 20);
        TestGraphBaseToString.assertEquals((int)17, (int)this.countTriples(((Object)((Object)g)).toString()));
    }

    private int countTriples(String string) {
        return string.replaceAll("[^;]+", "").length() + 1;
    }

    private void addTriples(Graph g, int from, int to) {
        for (int i = from; i <= to; ++i) {
            g.add(NodeCreateUtils.createTriple("s p " + i));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LittleGraphBase
    extends GraphBase {
        Set<Triple> triples = new HashSet<Triple>();

        private LittleGraphBase() {
        }

        public void performAdd(Triple t) {
            this.triples.add(t);
        }

        protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
            return WrappedIterator.create(this.triples.iterator());
        }
    }
}

