/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.MetaTestGraph;
import com.hp.hpl.jena.graph.test.TestGraphListener;
import com.hp.hpl.jena.graph.test.TestRegisterGraphListener;
import com.hp.hpl.jena.graph.test.TestReifier;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.mem.SmallGraphMem;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGraph
extends GraphTestBase {
    public TestGraph(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite(TestGraph.class);
        result.addTest((Test)TestGraph.suite(MetaTestGraph.class, GraphMem.class));
        result.addTest((Test)TestGraph.suite(TestReifier.class, GraphMem.class));
        result.addTest((Test)TestGraph.suite(MetaTestGraph.class, SmallGraphMem.class));
        result.addTest((Test)TestGraph.suite(TestReifier.class, SmallGraphMem.class));
        result.addTest((Test)TestGraph.suite(MetaTestGraph.class, WrappedGraphMem.class));
        result.addTest((Test)TestGraph.suite(TestReifier.class, WrappedGraphMem.class));
        result.addTest((Test)TestGraphListener.suite());
        result.addTestSuite(TestRegisterGraphListener.class);
        return result;
    }

    public static TestSuite suite(Class<? extends Test> classWithTests, Class<? extends Graph> graphClass) {
        return MetaTestGraph.suite(classWithTests, graphClass);
    }

    public void testWrappedSame() {
        Graph m = Factory.createGraphMem();
        WrappedGraph w = new WrappedGraph(m);
        TestGraph.graphAdd(m, "a trumps b; c eats d");
        TestGraph.assertIsomorphic(m, (Graph)w);
        TestGraph.graphAdd((Graph)w, "i write this; you read that");
        TestGraph.assertIsomorphic((Graph)w, m);
    }

    public void testListSubjectsDoesntUseFind() {
        boolean[] called = new boolean[]{false};
        Graph g = Factory.createGraphMem();
        ExtendedIterator subjects = g.queryHandler().subjectsFor(null, null);
        Set s = CollectionFactory.createHashedSet();
        while (subjects.hasNext()) {
            s.add(subjects.next());
        }
        TestGraph.assertFalse((String)"find should not have been called", (boolean)called[0]);
    }

    public void testListPredicatesDoesntUseFind() {
        boolean[] called = new boolean[]{false};
        Graph g = Factory.createGraphMem();
        ExtendedIterator predicates = g.queryHandler().predicatesFor(null, null);
        Set s = CollectionFactory.createHashedSet();
        while (predicates.hasNext()) {
            s.add(predicates.next());
        }
        TestGraph.assertFalse((String)"find should not have been called", (boolean)called[0]);
    }

    public void testListObjectsDoesntUseFind() {
        boolean[] called = new boolean[]{false};
        Graph g = Factory.createGraphMem();
        ExtendedIterator subjects = g.queryHandler().objectsFor(null, null);
        Set s = CollectionFactory.createHashedSet();
        while (subjects.hasNext()) {
            s.add(subjects.next());
        }
        TestGraph.assertFalse((String)"find should not have been called", (boolean)called[0]);
    }

    public static class WrappedGraphMem
    extends WrappedGraph {
        public WrappedGraphMem(ReificationStyle style) {
            super(Factory.createGraphMem((ReificationStyle)style));
        }
    }
}

