/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.xsd.AbstractDateTime;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDateTime
extends TestCase {
    static final XSDDateTime time0 = TestDateTime.makeDateTime("2009-08-13T17:54:40.348Z");
    static final XSDDateTime time1 = TestDateTime.makeDateTime("2009-08-13T18:54:39Z");
    static final XSDDateTime time2 = TestDateTime.makeDateTime("2009-08-13T18:54:40Z");
    static final XSDDateTime time3 = TestDateTime.makeDateTime("2009-08-13T18:54:40.348Z");
    static final XSDDateTime time4 = TestDateTime.makeDateTime("2009-08-13T18:54:40.505Z");
    static final XSDDateTime time5 = TestDateTime.makeDateTime("2009-08-13T18:54:40.77Z");
    static final XSDDateTime time6 = TestDateTime.makeDateTime("2009-08-13T18:54:40.88Z");
    static final XSDDateTime time7 = TestDateTime.makeDateTime("2009-08-13T18:54:40.989Z");
    static final XSDDateTime time8 = TestDateTime.makeDateTime("2009-08-13T19:54:40.989Z");
    static final XSDDateTime time9 = TestDateTime.makeDateTime("2009-08-13T18:54:40.077Z");
    static final XSDDateTime time10 = TestDateTime.makeDateTime("2009-08-13T18:54:40.770Z");

    public TestDateTime(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDateTime.class);
    }

    static XSDDateTime makeDateTime(String time) {
        return (XSDDateTime)XSDDatatype.XSDdateTime.parse(time);
    }

    public void testXSDOrder() {
        TestDateTime.assertEquals((int)time0.compare((AbstractDateTime)time1), (int)-1);
        TestDateTime.assertEquals((int)time1.compare((AbstractDateTime)time2), (int)-1);
        TestDateTime.assertEquals((int)time2.compare((AbstractDateTime)time3), (int)-1);
        TestDateTime.assertEquals((int)time3.compare((AbstractDateTime)time4), (int)-1);
        TestDateTime.assertEquals((int)time4.compare((AbstractDateTime)time5), (int)-1);
        TestDateTime.assertEquals((int)time5.compare((AbstractDateTime)time6), (int)-1);
        TestDateTime.assertEquals((int)time6.compare((AbstractDateTime)time7), (int)-1);
        TestDateTime.assertEquals((int)time7.compare((AbstractDateTime)time8), (int)-1);
        TestDateTime.assertEquals((int)time9.compare((AbstractDateTime)time5), (int)-1);
        TestDateTime.assertEquals((int)time9.compare((AbstractDateTime)time3), (int)-1);
        TestDateTime.assertEquals((int)time9.compare((AbstractDateTime)time2), (int)1);
        TestDateTime.assertEquals((int)time5.compare((AbstractDateTime)time10), (int)0);
    }

    public void testJavaOrder() {
        TestDateTime.assertEquals((int)time0.compareTo((AbstractDateTime)time1), (int)-1);
        TestDateTime.assertEquals((int)time1.compareTo((AbstractDateTime)time2), (int)-1);
        TestDateTime.assertEquals((int)time2.compareTo((AbstractDateTime)time3), (int)-1);
        TestDateTime.assertEquals((int)time3.compareTo((AbstractDateTime)time4), (int)-1);
        TestDateTime.assertEquals((int)time4.compareTo((AbstractDateTime)time5), (int)-1);
        TestDateTime.assertEquals((int)time5.compareTo((AbstractDateTime)time6), (int)-1);
        TestDateTime.assertEquals((int)time6.compareTo((AbstractDateTime)time7), (int)-1);
        TestDateTime.assertEquals((int)time7.compareTo((AbstractDateTime)time8), (int)-1);
    }

    public void testRoundTripping() {
        Model m = ModelFactory.createDefaultModel();
        Property startTime = m.createProperty("http://jena.hpl.hp.com/test#startTime");
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        Literal xsdlit0 = m.createTypedLiteral(cal);
        Resource event = m.createResource();
        event.addProperty(startTime, (RDFNode)xsdlit0);
        StringWriter sw = new StringWriter();
        m.write((Writer)sw);
        StringReader reader = new StringReader(sw.toString());
        Model m1 = ModelFactory.createDefaultModel();
        m1.read((Reader)reader, null);
        TestDateTime.assertTrue((boolean)m.isIsomorphicWith(m1));
        Literal xsdlit1 = (Literal)((Statement)m1.listStatements().next()).getObject().as(Literal.class);
        TestDateTime.assertEquals((Object)xsdlit0, (Object)xsdlit1);
    }
}

