/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.CompositionBase;
import com.hp.hpl.jena.graph.compose.Dyadic;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDyadic
extends GraphTestBase {
    public TestDyadic(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDyadic.class);
    }

    private static ExtendedIterator<String> things(final String x) {
        return new NiceIterator<String>(){
            private StringTokenizer tokens;
            {
                this.tokens = new StringTokenizer(x);
            }

            public boolean hasNext() {
                return this.tokens.hasMoreTokens();
            }

            public String next() {
                return this.tokens.nextToken();
            }
        };
    }

    public void testDyadic() {
        ExtendedIterator<String> it1 = TestDyadic.things("now is the time");
        ExtendedIterator<String> it2 = TestDyadic.things("now is the time");
        ExtendedIterator<String> mt1 = TestDyadic.things("");
        ExtendedIterator<String> mt2 = TestDyadic.things("");
        TestDyadic.assertEquals((String)"mt1.hasNext()", (boolean)false, (boolean)mt1.hasNext());
        TestDyadic.assertEquals((String)"mt2.hasNext()", (boolean)false, (boolean)mt2.hasNext());
        TestDyadic.assertEquals((String)"andThen(mt1,mt2).hasNext()", (boolean)false, (boolean)mt1.andThen(mt2).hasNext());
        TestDyadic.assertEquals((String)"butNot(it1,it2).hasNext()", (boolean)false, (boolean)CompositionBase.butNot(it1, it2).hasNext());
        TestDyadic.assertEquals((String)"x y z @butNot z", (boolean)true, (boolean)CompositionBase.butNot(TestDyadic.things("x y z"), TestDyadic.things("z")).hasNext());
        TestDyadic.assertEquals((String)"x y z @butNot a", (boolean)true, (boolean)CompositionBase.butNot(TestDyadic.things("x y z"), TestDyadic.things("z")).hasNext());
    }

    public void testDyadicOperands() {
        Graph g = Factory.createGraphMem();
        Graph h = Factory.createGraphMem();
        Dyadic d = new Dyadic(g, h){

            public ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
                return null;
            }
        };
        TestDyadic.assertSame((Object)g, (Object)d.getL());
        TestDyadic.assertSame((Object)h, (Object)d.getR());
    }
}

