/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestBasicOperations;
import com.hp.hpl.jena.db.test.TestCompareToMem;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.db.test.TestDriverMap;
import com.hp.hpl.jena.db.test.TestGraphRDB;
import com.hp.hpl.jena.db.test.TestGraphRDBMaker;
import com.hp.hpl.jena.db.test.TestModelRDB;
import com.hp.hpl.jena.db.test.TestMultiModel;
import com.hp.hpl.jena.db.test.TestNsPrefix;
import com.hp.hpl.jena.db.test.TestPrefixMapping;
import com.hp.hpl.jena.db.test.TestQuery1;
import com.hp.hpl.jena.db.test.TestQueryRDB;
import com.hp.hpl.jena.db.test.TestRDBAssemblerContents;
import com.hp.hpl.jena.db.test.TestReifier;
import com.hp.hpl.jena.db.test.TestReifierCompareToMem;
import com.hp.hpl.jena.db.test.TestSimpleSelector;
import com.hp.hpl.jena.db.test.TestTransactions;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelFactoryBase;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPackage
extends TestCase {
    public static String M_DB_URL = ModelFactoryBase.guessDBURL();
    public static String M_DB_USER = ModelFactoryBase.guessDBUser();
    public static String M_DB_PASSWD = ModelFactoryBase.guessDBPassword();
    public static String M_DB = ModelFactoryBase.guessDBType();
    public static String M_DBDRIVER_CLASS = ModelFactoryBase.guessDBDriver();
    public static boolean M_DBCONCURRENT = ModelFactoryBase.guessDBConcurrent();

    public static TestSuite suite() {
        TestSuite ts = new TestSuite();
        try {
            ts.setName("GraphRDB");
            TestPackage.addTest(ts, "TestDriverMap", TestDriverMap.suite());
            TestPackage.addTest(ts, "TestConnection", TestConnection.suite());
            TestPackage.addTest(ts, "TestBasicOperations", TestBasicOperations.suite());
            TestPackage.addTest(ts, "TestSimpleSelector", TestSimpleSelector.suite());
            TestPackage.addTest(ts, "TestCompareToMem", TestCompareToMem.suite());
            TestPackage.addTest(ts, "TestGraphRDB", TestGraphRDB.suite());
            TestPackage.addTest(ts, "TestModelRDB", TestModelRDB.suite());
            TestPackage.addTest(ts, "TestGraphRDBMaker", TestGraphRDBMaker.suite());
            TestPackage.addTest(ts, "TestMultiModel", TestMultiModel.suite());
            TestPackage.addTest(ts, "TestNsPrefix", TestNsPrefix.suite());
            TestPackage.addTest(ts, "TestPrefixMapping", TestPrefixMapping.suite());
            TestPackage.addTest(ts, "TestTransactions", TestTransactions.suite());
            TestPackage.addTest(ts, "TestReifier", TestReifier.suite());
            TestPackage.addTest(ts, "TestReifierCompareToMem", TestReifierCompareToMem.suite());
            TestPackage.addTest(ts, "TestQueryRDB", TestQueryRDB.suite());
            TestPackage.addTest(ts, "TestQuery1", TestQuery1.suite());
            TestPackage.addTest(ts, "TestModelFactory", TestModelFactory.suite());
            ts.addTestSuite(TestRDBAssemblerContents.class);
            return ts;
        }
        catch (Error ex) {
            ex.printStackTrace(System.err);
            return ts;
        }
    }

    private static void addTest(TestSuite ts, String name, TestSuite tc) {
        if (name != null) {
            tc.setName(name);
        }
        ts.addTest((Test)tc);
    }

    public static class TestModelFactory
    extends TestCase {
        public TestModelFactory(String name) {
            super(name);
        }

        public static TestSuite suite() {
            return new TestSuite(TestModelFactory.class);
        }

        public void testModelFactory() {
            IDBConnection c = TestConnection.makeAndCleanTestConnection();
            TestModelFactory.assertTrue((boolean)(ModelFactory.createModelRDBMaker((IDBConnection)c).createFreshModel() instanceof ModelRDB));
        }
    }
}

