/*
 * (c) Copyright 2008, 2009 Hewlett-Packard Development Company, LP
 * All rights reserved.
 * [See end of file]
 */

package com.hp.hpl.jena.tdb.sys;

public class Names
{
    public static final String primaryIndexTriples = "SPO" ; 
    public static final String[] tripleIndexes = { primaryIndexTriples, "POS", "OSP" } ;

    public static final String primaryIndexQuads = "GSPO" ; 
    public static final String[] quadIndexes = { primaryIndexQuads, "GPOS", "GOSP", "POSG", "OSPG", "SPOG"} ;

    
    /** B+Trees - nodes file and records file */
    public static final String bptExt1          = "idn" ;
    public static final String bptExt2          = "dat" ;

    /** BTrees - single file per tree */
    public static final String btExt            = "idx" ;
    
    /** ExtHash - dictionary file*/
    public static final String extHashExt       = "exh" ;
    public static final String extHashBucketExt = "dat" ;
    
    /** Node file */
    public static final String nodesData        = "nodes.dat" ;     // Node table
    public static final String indexNode2Id     = "node2id";        // Node hash to id table
    
    //public static final String indexId2Node     = "id2node";        // Would be the Index for node(hash) to id  

    /** Prefixes file */
    public static final String prefixesData     = "prefixes.dat" ;  // Prefix node table 
    public static final String indexPrefix2Id   = "prefix2id";      // Prefix node table for index Node/hash->id
    
    public static final String indexPrefix      = "prefixIdx";      // Primary key on the prefixes table. 
    
    /** Optimizer / stats */
    public static final String optStats         = "stats.opt";
    public static final String optDefault       = "fixed.opt";      // Currently, it's just the presence of this file that matters.
    public static final String optNone          = "none.opt"; 
}

/*
 * (c) Copyright 2008, 2009 Hewlett-Packard Development Company, LP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */