/*
 * Decompiled with CFR 0.152.
 */
package jena;

import arq.cmd.CmdException;
import arq.cmd.TerminationException;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import com.hp.hpl.jena.sparql.vocabulary.ResultSetGraphVocab;
import com.hp.hpl.jena.util.FileManager;
import java.io.OutputStream;
import jena.cmdline.ArgDecl;
import jena.util.DBcmd;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class dbquery
extends DBcmd {
    private static Log log = LogFactory.getLog((Class)dbquery.class);
    public static final String[] usage = new String[]{"dbquery [db_description] [--model name] --query QueryFile", "  where db_description is", "    --db JDBC URL --dbType type", "    --dbUser user --dbPassword password"};
    private ArgDecl queryDecl = new ArgDecl(true, "query");
    private ArgDecl queryTime = new ArgDecl(false, "time");
    private ArgDecl repeatDecl = new ArgDecl(true, "repeat");
    private boolean timing = false;

    public static void main(String[] argv) {
        block3: {
            try {
                dbquery.main2(argv);
            }
            catch (TerminationException ex) {
                System.exit(ex.getCode());
            }
            catch (CmdException ex) {
                System.err.println(ex.getMessage());
                if (ex.getCause() == null) break block3;
                ex.getCause().printStackTrace(System.err);
            }
        }
    }

    public static void main2(String[] argv) {
        dbquery db = new dbquery();
        db.setUsage(usage);
        db.init(argv);
        db.exec();
    }

    public dbquery() {
        super("dbquery", false);
        this.getCommandLine().add(this.queryDecl);
        this.getCommandLine().add(this.queryTime);
        this.getCommandLine().add(this.repeatDecl);
    }

    protected void exec0() {
        if (!this.getCommandLine().contains(this.queryDecl)) {
            System.err.println("No query");
            return;
        }
        String queryFile = this.getCommandLine().getValue(this.queryDecl);
        String queryString = FileManager.get().readWholeFileAsUTF8(queryFile);
        this.exec1(queryString);
    }

    protected boolean exec1(String arg) {
        if (arg.startsWith("@")) {
            arg = FileManager.get().readWholeFileAsUTF8(arg.substring(1));
        }
        boolean timing = false;
        if (this.getCommandLine().contains(this.queryTime)) {
            timing = true;
        }
        long totalTime = 0L;
        long firstTime = 0L;
        ResultsFormat fmt = ResultsFormat.FMT_TEXT;
        int repeat = 1;
        if (this.getCommandLine().contains(this.repeatDecl)) {
            repeat = Integer.parseInt(this.getCommandLine().getValue(this.repeatDecl));
        }
        if (timing) {
            fmt = ResultsFormat.FMT_NONE;
        }
        if (timing) {
            long startTime = System.currentTimeMillis();
            Query query2 = QueryFactory.create((String)arg);
            Model m = ModelFactory.createDefaultModel();
            QueryExecution qExec = QueryExecutionFactory.create((Query)query2, (Model)m);
            this.doQuery(query2, qExec, ResultsFormat.FMT_NONE);
            long finishTime = System.currentTimeMillis();
            firstTime = finishTime - startTime;
        }
        long startTimeJDBC = System.currentTimeMillis();
        this.getRDBModel();
        long jdbcTime = System.currentTimeMillis() - startTimeJDBC;
        for (int i = 0; i < repeat; ++i) {
            long startTime = System.currentTimeMillis();
            Query query3 = QueryFactory.create((String)arg);
            QueryExecution qExec = QueryExecutionFactory.create((Query)query3, (Model)super.getRDBModel());
            this.doQuery(query3, qExec, fmt);
            qExec.close();
            long finishTime = System.currentTimeMillis();
            long time = finishTime - startTime;
            totalTime += time;
        }
        if (timing) {
            System.out.println("Query execution time:   " + (double)totalTime / ((double)repeat * 1000.0));
            System.out.println("Setup:                  " + (double)firstTime / 1000.0);
            System.out.println("JDBC setup:             " + (double)jdbcTime / 1000.0);
        }
        return false;
    }

    public void doQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        if (query2.isSelectType()) {
            this.doSelectQuery(query2, qe, outputFormat);
        }
        if (query2.isDescribeType()) {
            this.doDescribeQuery(query2, qe, outputFormat);
        }
        if (query2.isConstructType()) {
            this.doConstructQuery(query2, qe, outputFormat);
        }
        if (query2.isAskType()) {
            this.doAskQuery(query2, qe, outputFormat);
        }
        qe.close();
    }

    void doSelectQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        ResultSet results = qe.execSelect();
        results = ResultSetFactory.makeRewindable((ResultSet)results);
        boolean done = false;
        if (outputFormat.equals((Object)ResultsFormat.FMT_NONE) || outputFormat.equals((Object)ResultsFormat.FMT_COUNT)) {
            int count = ResultSetFormatter.consume((ResultSet)results);
            if (outputFormat.equals((Object)ResultsFormat.FMT_COUNT)) {
                System.out.println("Count = " + count);
            }
            done = true;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RS_RDF) || outputFormat.equals((Object)ResultsFormat.FMT_RDF_N3)) {
            Model m = ResultSetFormatter.toModel((ResultSet)results);
            m.setNsPrefixes(query2.getPrefixMapping());
            RDFWriter rdfw = m.getWriter("TURTLE");
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
            rdfw.write(m, System.out, null);
            done = true;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, (ResultSet)results);
            done = true;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_TEXT)) {
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)results, (PrefixMapping)query2.getPrefixMapping());
            done = true;
        }
        if (!done) {
            log.warn((Object)("Unknown format request: " + outputFormat));
        }
        System.out.flush();
    }

    void doDescribeQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        Model r = qe.execDescribe();
        this.writeModel(query2, r, outputFormat);
    }

    void doConstructQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        Model r = qe.execConstruct();
        this.writeModel(query2, r, outputFormat);
    }

    void writeModel(Query query2, Model model, ResultsFormat outputFormat) {
        if (outputFormat.equals((Object)ResultsFormat.FMT_NONE)) {
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_TEXT)) {
            String qType = "";
            if (query2.isDescribeType()) {
                qType = "DESCRIBE";
            }
            if (query2.isConstructType()) {
                qType = "CONSTRUCT";
            }
            System.out.println("# ======== " + qType + " results ");
            model.write(System.out, "N3", null);
            System.out.println("# ======== ");
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RDF_XML)) {
            model.write(System.out, "RDF/XML-ABBREV", null);
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RDF_N3)) {
            model.write(System.out, "N3", null);
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RDF_NT)) {
            model.write(System.out, "N_TRIPLES", null);
            return;
        }
        System.err.println("Unknown format: " + outputFormat.getSymbol());
    }

    void doAskQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        boolean b = qe.execAsk();
        if (outputFormat.equals((Object)ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, (boolean)b);
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RDF_N3) || outputFormat.equals((Object)ResultsFormat.FMT_RDF_TTL)) {
            ResultSetFormatter.outputAsRDF((OutputStream)System.out, (String)"TURTLE", (boolean)b);
            System.out.flush();
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_TEXT)) {
            System.out.println("Ask => " + (b ? "Yes" : "No"));
            return;
        }
        System.err.println("Unknown format: " + outputFormat.getSymbol());
    }
}

