/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.optimizer.Optimizer;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndex;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndexModel;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAPI
extends TestCase {
    private static Model graphM = null;
    private static Model indexM = null;
    private static ProbabilityIndex index = null;
    private static ProbabilityIndexModel probability = null;
    private static Query query = null;
    private static Set exProperty = new HashSet();
    private static final Property firstnameP = ResourceFactory.createProperty((String)"http://example.org#firstname");
    private static final Property lastnameP = ResourceFactory.createProperty((String)"http://example.org#lastname");
    private static final Property workplaceP = ResourceFactory.createProperty((String)"http://example.org#workplace");
    private static final Property msnP = ResourceFactory.createProperty((String)"http://example.org#msn");
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";

    public TestAPI(String title) {
        super(title);
    }

    public static void oneTimeSetUp() {
        graphM = Util.readModel(testDataFileName);
        probability = (ProbabilityIndexModel)ProbabilityFactory.createIndexModel((Model)Util.readModel(testDataFileName));
        index = probability.getIndex();
        indexM = index.getModel();
        ElementTriplesBlock el = new ElementTriplesBlock();
        el.addTriple(new Triple((Node)Var.alloc((String)"x"), (Node)Var.alloc((String)"y"), (Node)Var.alloc((String)"z")));
        query = QueryFactory.make();
        query.setQuerySelectType();
        query.setQueryResultStar(true);
        query.setQueryPattern((Element)el);
        exProperty.add(firstnameP);
        exProperty.add(lastnameP);
        exProperty.add(workplaceP);
        exProperty.add(RDF.type);
        exProperty.add(RDF.first);
    }

    public static void oneTimeTearDown() {
        graphM.close();
    }

    public void testOptimizerEnable() {
        Optimizer.enable();
        Optimizer.enable(null);
        Optimizer.enable((Config)new Config("BGP_VARIABLE_COUNTING"));
        Optimizer.enable((Context)ARQ.getContext(), (Config)new Config("BGP_VARIABLE_COUNTING"));
        Optimizer.enable((Model)graphM, (Model)indexM);
        Optimizer.enable((Model)graphM, (Model)indexM, null);
        Optimizer.enable((Model)graphM, (Model)indexM, (Config)new Config("BGP_VARIABLE_COUNTING"));
        Optimizer.enable((Context)ARQ.getContext(), (Model)graphM, (Model)indexM, null);
        Optimizer.enable((Context)ARQ.getContext(), (Model)graphM, (Model)indexM, (Config)new Config("BGP_VARIABLE_COUNTING"));
    }

    public void testOptimizerDisable() {
        Optimizer.disable();
        Optimizer.disable((Context)ARQ.getContext());
    }

    public void testExplain() {
        Optimizer.explain((Model)graphM, (Query)query);
        Optimizer.explain((Model)graphM, (Query)query, null);
        Optimizer.explain((Model)graphM, (Query)query, (Config)new Config("BGP_VARIABLE_COUNTING"));
        Optimizer.explain((Context)ARQ.getContext(), (Model)graphM, (Query)query, null);
        Optimizer.explain((Context)ARQ.getContext(), (Model)graphM, (Query)query, (Config)new Config("BGP_VARIABLE_COUNTING"));
    }

    public void testIndex() {
        Optimizer.index((Model)graphM);
        Optimizer.index((Model)graphM, (Config)new Config(0));
        Optimizer.index((Model)graphM, (Config)new Config(1));
        Optimizer.index((Model)graphM, (Config)new Config(exProperty));
        Model indexM = Optimizer.index((Model)graphM, (Config)new Config(0, exProperty));
        ProbabilityIndexModel probability = (ProbabilityIndexModel)ProbabilityFactory.loadIndexModel((Model)graphM, (Model)indexM, null);
        ProbabilityIndex index = probability.getIndex();
        Map properties = index.getProperties();
        Map histograms = index.getHistograms();
        TestAPI.assertTrue((!index.allowsJoinedProbability() ? 1 : 0) != 0);
        TestAPI.assertTrue((properties.containsKey(msnP) ? 1 : 0) != 0);
        TestAPI.assertTrue((!properties.containsKey(firstnameP) ? 1 : 0) != 0);
        TestAPI.assertTrue((!properties.containsKey(lastnameP) ? 1 : 0) != 0);
        TestAPI.assertTrue((histograms.containsKey(msnP) ? 1 : 0) != 0);
        TestAPI.assertTrue((!histograms.containsKey(firstnameP) ? 1 : 0) != 0);
        TestAPI.assertTrue((!histograms.containsKey(lastnameP) ? 1 : 0) != 0);
    }

    public void testProbability1() {
        ProbabilityFactory.createDefaultModel((Model)graphM, null);
        ProbabilityFactory.createDefaultModel((Graph)graphM.getGraph(), null);
        ProbabilityFactory.createIndex((Model)graphM);
        ProbabilityFactory.createIndex((Graph)graphM.getGraph());
        ProbabilityFactory.createIndex((Model)graphM, (Config)new Config(exProperty));
        ProbabilityFactory.createIndex((Model)graphM, (Config)new Config(1, exProperty));
        ProbabilityFactory.createIndexModel((Model)graphM, (Config)new Config(1, exProperty));
        ProbabilityFactory.loadDataModel((Model)graphM, null);
        ProbabilityFactory.loadDataModel((Graph)graphM.getGraph(), null);
        ProbabilityFactory.loadDefaultModel((Model)graphM, (Model)indexM, null);
        ProbabilityFactory.loadDefaultModel((Graph)graphM.getGraph(), (Model)indexM, null);
        ProbabilityFactory.loadIndexModel((Model)graphM, (Model)indexM, null);
    }

    public void testProbability2() {
        ProbabilityFactory.createDefaultModel((Model)graphM, (Config)new Config());
        ProbabilityFactory.createDefaultModel((Graph)graphM.getGraph(), (Config)new Config());
        ProbabilityFactory.createIndex((Model)graphM);
        ProbabilityFactory.createIndex((Graph)graphM.getGraph());
        ProbabilityFactory.createIndex((Model)graphM, (Config)new Config(exProperty));
        ProbabilityFactory.createIndex((Model)graphM, (Config)new Config(1, exProperty));
        ProbabilityFactory.createIndexModel((Model)graphM, (Config)new Config(1, exProperty));
        ProbabilityFactory.loadDataModel((Model)graphM, (Config)new Config());
        ProbabilityFactory.loadDataModel((Graph)graphM.getGraph(), (Config)new Config());
        ProbabilityFactory.loadDefaultModel((Model)graphM, (Model)indexM, (Config)new Config());
        ProbabilityFactory.loadDefaultModel((Graph)graphM.getGraph(), (Model)indexM, (Config)new Config());
        ProbabilityFactory.loadIndexModel((Model)graphM, (Model)indexM, (Config)new Config());
    }

    public static Test suite() {
        TestSuite ts = new TestSuite("TestAPI");
        ts.addTest((Test)new TestAPI("testOptimizerDisable"));
        ts.addTest((Test)new TestAPI("testOptimizerEnable"));
        ts.addTest((Test)new TestAPI("testExplain"));
        ts.addTest((Test)new TestAPI("testIndex"));
        ts.addTest((Test)new TestAPI("testProbability1"));
        ts.addTest((Test)new TestAPI("testProbability2"));
        TestSetup wrapper = new TestSetup((Test)ts){

            protected void setUp() {
                TestAPI.oneTimeSetUp();
            }

            protected void tearDown() {
                TestAPI.oneTimeTearDown();
            }
        };
        return wrapper;
    }
}

