/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.hp.hpl.jena.tdb.base.block.BlockMgrMem;
import com.hp.hpl.jena.tdb.index.IndexTestGenerator;
import com.hp.hpl.jena.tdb.index.RangeIndexMaker;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import tdb.Cmd;
import test.ExecGenerator;
import test.RunnerExecute;

public abstract class RunnerRangeIndex
extends RunnerExecute {
    int order;
    int maxValue;
    int maxNumKeys;

    protected abstract RangeIndexMaker makeRangeIndexMaker();

    @Override
    protected ExecGenerator execGenerator() {
        RangeIndexMaker maker = this.makeRangeIndexMaker();
        IndexTestGenerator test = new IndexTestGenerator(maker, this.maxValue, this.maxNumKeys);
        return test;
    }

    @Override
    protected int startRun(List<String> args, RunnerExecute.RunType runType) {
        this.startRun(runType);
        this.order = Integer.parseInt(args.get(0));
        int numKeys = Integer.parseInt(args.get(1));
        int iterations = Integer.parseInt(args.get(2));
        this.maxValue = 10 * numKeys;
        this.maxNumKeys = numKeys;
        return iterations;
    }

    protected abstract void startRun(RunnerExecute.RunType var1);

    @Override
    protected void finishRun() {
    }

    @Override
    protected List<String> processArgs(List<String> args) {
        Cmd.setLog4j();
        boolean i = false;
        while (args.size() > 0 && args.get(0).startsWith("-")) {
            String a = args.remove(0);
            a = a.startsWith("--") ? a.substring(2) : a.substring(1);
            if (a.equals("h") || a.equals("help")) {
                RunnerRangeIndex.usage(System.out);
                System.exit(0);
                continue;
            }
            if (a.equals("v")) {
                BPlusTreeParams.DumpTree = true;
                continue;
            }
            if (a.equalsIgnoreCase("bptree:check")) {
                BPlusTreeParams.CheckingTree = true;
                SystemTDB.NullOut = true;
                continue;
            }
            if (a.equalsIgnoreCase("bptree:checknode")) {
                BPlusTreeParams.CheckingNode = true;
                SystemTDB.NullOut = true;
                BlockMgrMem.SafeMode = true;
                continue;
            }
            if (a.equalsIgnoreCase("bptree:log")) {
                showProgress = false;
                LogManager.getLogger((String)"bptree").setLevel(Level.DEBUG);
                LogManager.getLogger((String)"bptree.block").setLevel(Level.INFO);
                continue;
            }
            if (a.equalsIgnoreCase("block:log")) {
                showProgress = false;
                LogManager.getLogger((String)"bptree.block").setLevel(Level.DEBUG);
                continue;
            }
            if (a.equalsIgnoreCase("block:safe")) {
                BlockMgrMem.SafeMode = true;
                continue;
            }
            if (a.equalsIgnoreCase("check")) {
                BPlusTreeParams.CheckingNode = true;
                SystemTDB.NullOut = true;
                BlockMgrMem.SafeMode = true;
                continue;
            }
            if (a.equalsIgnoreCase("display")) {
                showProgress = !showProgress;
                continue;
            }
            System.err.println("Unknown argument: " + a);
            System.exit(1);
        }
        if (args.size() != 3) {
            RunnerRangeIndex.usage(System.err);
            System.exit(1);
        }
        return args;
    }
}

