/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexTestLib;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeMaker;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import test.ExecGenerator;
import test.Gen;
import test.RepeatExecution;

public abstract class RunnerExecute {
    static boolean showProgress = true;

    public void perform(String ... a) {
        List<String> args = new ArrayList<String>(Arrays.asList(a));
        if (args.size() == 0) {
            System.err.println("No subcommand");
            System.exit(1);
        }
        String subCmd = (String)args.remove(0);
        RunType runType = null;
        if ("test".equalsIgnoreCase(subCmd)) {
            runType = RunType.test;
        } else if ("perf".equalsIgnoreCase(subCmd)) {
            runType = RunType.perf;
        } else {
            System.err.println("Unknown subcommand: " + subCmd);
            System.exit(1);
        }
        args = this.processArgs(args);
        int iterations = this.startRun(args, runType);
        ExecGenerator gen = this.execGenerator();
        RepeatExecution.repeatExecutions(gen, iterations, showProgress);
        this.finishRun();
    }

    protected abstract List<String> processArgs(List<String> var1);

    protected abstract ExecGenerator execGenerator();

    protected abstract int startRun(List<String> var1, RunType var2);

    protected abstract void finishRun();

    public static void usage(PrintStream printStream) {
        printStream.println("Usage: OPTIONS Order NumKeys Iterations");
        printStream.println("Options:");
        printStream.println("   --display");
        printStream.println("   --check (same as btree:checknode)");
        printStream.println("   --bptree:check");
        printStream.println("   --bptree:checknode (expensive)");
        printStream.println("   --bptree:log");
        printStream.println("   --bptree:safe");
    }

    public static void perfTest(int order, int maxValue, int numKeys) {
        int[] keys1 = Gen.rand(numKeys, 0, maxValue);
        int[] keys2 = Gen.permute(keys1, numKeys);
        try {
            BPlusTreeMaker maker = new BPlusTreeMaker(order, order);
            Index rIndex = IndexTestLib.buildIndex(maker, keys1);
            IndexTestLib.delete(rIndex, keys2);
        }
        catch (RuntimeException ex) {
            System.err.printf("int order=%d ;\n", order);
            System.err.printf("int[] keys1 = {%s} ;\n", Gen.strings(keys1));
            System.err.printf("int[] keys2 = {%s} ; \n", Gen.strings(keys2));
            throw ex;
        }
    }

    static enum RunType {
        test,
        perf;

    }
}

