/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.hp.hpl.jena.tdb.index.ext.ExtHash;
import com.hp.hpl.jena.tdb.index.ext.ExtHashTestBase;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lib.RandomLib;
import tdb.Cmd;
import test.ExecGenerator;
import test.Gen;
import test.RepeatExecution;

public abstract class ExtHashRun {
    static boolean showProgress = true;

    public static void main(String ... a) {
        String subCmd;
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(a));
        if (args.size() == 0) {
            System.err.println("No subcommand");
            System.exit(1);
        }
        if ("test".equalsIgnoreCase(subCmd = (String)args.remove(0))) {
            new Test().exec(args);
        } else if ("perf".equalsIgnoreCase(subCmd)) {
            new Perf().exec(args);
        } else {
            System.err.println("Unknown subcommand: " + subCmd);
            System.exit(1);
        }
    }

    public void exec(List<String> args) {
        args = this.processArgs(args);
        int numKeys = Integer.parseInt(args.get(0));
        int iterations = Integer.parseInt(args.get(1));
        this.exec(numKeys, iterations);
    }

    protected abstract void exec(int var1, int var2);

    List<String> processArgs(List<String> args) {
        Cmd.setLog4j();
        boolean i = false;
        while (args.size() > 0 && args.get(0).startsWith("-")) {
            String a = args.remove(0);
            a = a.startsWith("--") ? a.substring(2) : a.substring(1);
            if (a.equals("h") || a.equals("help")) {
                ExtHashRun.usage(System.out);
                System.exit(0);
                continue;
            }
            if (a.equals("v")) continue;
            if (a.equalsIgnoreCase("check")) {
                ExtHash.Checking = true;
                continue;
            }
            if (a.equalsIgnoreCase("display")) {
                showProgress = !showProgress;
                continue;
            }
            System.err.println("Unknown argument: " + a);
            System.exit(1);
        }
        if (args.size() != 2) {
            ExtHashRun.usage(System.err);
            System.exit(1);
        }
        return args;
    }

    public static void usage(PrintStream printStream) {
        printStream.println("Usage: OPTIONS NumKeys Iterations");
        printStream.println("Options:");
        printStream.println("   --check");
    }

    static class RandomGen
    implements ExecGenerator {
        int maxNumKeys;
        int maxValue;

        RandomGen(int maxValue, int maxNumKeys) {
            if (maxValue <= maxNumKeys) {
                throw new IllegalArgumentException("ExtHash: Max value less than number of keys");
            }
            this.maxValue = maxValue;
            this.maxNumKeys = maxNumKeys;
        }

        @Override
        public void executeOneTest() {
            int numKeys = RandomLib.random.nextInt(this.maxNumKeys) + 1;
            RandomGen.perfTest(this.maxValue, numKeys);
        }

        public static void perfTest(int maxValue, int numKeys) {
            int[] keys1 = Gen.rand(numKeys, 0, maxValue);
            int[] keys2 = Gen.permute(keys1, numKeys);
            try {
                ExtHash extHash = ExtHashTestBase.create(keys1);
                ExtHashTestBase.delete(extHash, keys2);
            }
            catch (RuntimeException ex) {
                System.err.printf("int[] keys1 = {%s} ;\n", Gen.strings(keys1));
                System.err.printf("int[] keys2 = {%s}; \n", Gen.strings(keys2));
                throw ex;
            }
        }
    }

    public static class Perf
    extends ExtHashRun {
        @Override
        public void exec(List<String> args) {
            showProgress = true;
            ExtHash.Checking = false;
            ExtHash.Logging = false;
            SystemTDB.NullOut = false;
            super.exec(args);
        }

        @Override
        protected void exec(int numKeys, int iterations) {
            RandomGen rand = new RandomGen(100 * numKeys, numKeys);
            RepeatExecution.repeatExecutions(rand, iterations, showProgress);
        }
    }

    public static class Test
    extends ExtHashRun {
        @Override
        protected void exec(int numKeys, int iterations) {
            ExtHash.Checking = true;
            ExtHashTestBase.randTests(10 * numKeys, numKeys, iterations, showProgress);
        }
    }
}

