/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import com.hp.hpl.jena.tdb.InstallationTest;
import com.hp.hpl.jena.tdb.TDB;
import java.io.File;
import java.io.PrintStream;
import org.junit.internal.TextListener;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class tdbtest {
    public static void main(String ... argv) {
        tdbtest.ensureDir("tmp");
        tdbtest.ensureDir("tmp/testing");
        PrintStream out = System.out;
        if (TDB.VERSION.equals("DEV")) {
            out.printf("TDB test suite\n", new Object[0]);
        } else {
            out.printf("TDB v%s test suite (Built: %s)\n", TDB.VERSION, TDB.BUILD_DATE);
        }
        JUnitCore runner = new JUnitCore();
        runner.addListener((RunListener)new MyTextListener(out));
        Result result = runner.run(new Class[]{InstallationTest.class});
        if (result.getFailureCount() > 0) {
            System.exit(1);
        }
    }

    private static void ensureDir(String dirname) {
        File dir = new File(dirname);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    static class MyTextListener
    extends TextListener {
        private PrintStream out;
        int count = 0;

        public MyTextListener(PrintStream writer) {
            super(writer);
            this.out = writer;
        }

        public void testRunStarted(Description description) {
        }

        public void testStarted(Description description) {
            this.newline();
            this.out.append('.');
        }

        private void newline() {
            if (this.count != 0 && this.count % 50 == 0) {
                this.out.println();
            }
            ++this.count;
        }

        public void testFailure(Failure failure) {
            this.newline();
            this.out.append('E');
        }

        public void testIgnored(Description description) {
            this.newline();
            this.out.append('I');
        }
    }
}

