/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import arq.cmd.CmdUtils;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import tdb.cmdline.CmdTDB;

public class tdbnode
extends CmdTDB {
    public static void main(String ... argv) {
        CmdUtils.setLog4j();
        new tdbnode(argv).mainRun();
    }

    protected tdbnode(String[] argv) {
        super(argv);
    }

    protected String getSummary() {
        return this.getCommandName() + " NodeId ...";
    }

    protected void exec() {
        GraphTDB graph = this.getGraph();
        NodeTable nodeTable = graph.getNodeTupleTable().getNodeTable();
        Iterator iter = super.getPositional().iterator();
        if (!iter.hasNext()) {
            System.err.println("No node ids");
            return;
        }
        while (iter.hasNext()) {
            String id = (String)iter.next();
            try {
                long x = Long.parseLong(id);
                NodeId nodeId = new NodeId(x);
                Node n = nodeTable.getNodeForNodeId(nodeId);
                System.out.printf("%s [%d] => %s\n", id, x, n);
            }
            catch (Exception ex) {
                System.out.println("Failed to decode: " + id);
            }
        }
    }
}

