/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import arq.cmd.CmdUtils;
import arq.cmdline.ArgDecl;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.tdb.pgraph.PGraph;
import com.hp.hpl.jena.tdb.store.BulkLoader;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import java.util.List;
import lib.Log;
import tdb.cmdline.CmdTDB;

public class tdbloader
extends CmdTDB {
    private static final ArgDecl argParallel = new ArgDecl(false, "parallel");
    private static final ArgDecl argIncremental = new ArgDecl(false, "incr", "incremental");
    private static final ArgDecl argStats = new ArgDecl(false, "stats");
    private boolean timing = true;
    private boolean doInParallel = false;
    private boolean doIncremental = false;
    private boolean generateStats = false;

    public static void main(String ... argv) {
        CmdUtils.setLog4j();
        new tdbloader(argv).mainRun();
    }

    protected tdbloader(String[] argv) {
        super(argv);
        super.add(argParallel, "--parallel", "Do rebuilding of secondary indexes in a parallel");
        super.add(argIncremental, "--incremental", "Do an incremental load (keep indexes during load, don't rebuild)");
        super.add(argStats, "--stats", "Generate statistics while loading (new graph only)");
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        this.doInParallel = super.contains(argParallel);
        this.doIncremental = super.contains(argIncremental);
        this.generateStats = super.contains(argStats);
    }

    protected String getSummary() {
        return this.getCommandName() + " [--desc DATASET | -loc DIR] FILE ...";
    }

    protected void exec() {
        List urls;
        if (this.isVerbose()) {
            System.out.println("Java maximum memory: " + Runtime.getRuntime().maxMemory());
            System.out.println(ARQ.getContext());
        }
        if (this.isVerbose()) {
            this.timing = true;
        }
        if (this.isQuiet()) {
            this.timing = false;
        }
        if ((urls = this.getPositional()).size() == 0) {
            urls.add("-");
        }
        if (this.graphName == null) {
            GraphTDB graph = this.getGraph();
            if (graph instanceof PGraph) {
                Log.fatal((Object)this, "Old PGraph");
                return;
            }
            BulkLoader loader = new BulkLoader(graph, this.timing, this.doInParallel, this.doIncremental, this.generateStats);
            loader.load(urls);
        } else {
            Model model = this.getModel();
            BulkLoader.loadSimple(model, urls, this.timing);
        }
    }
}

