/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import arq.cmd.CmdUtils;
import arq.cmdline.CmdARQ;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.iri.Violation;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.sparql.util.graph.GraphSink;
import com.hp.hpl.jena.tdb.base.reader.NTriplesReader2;
import com.hp.hpl.jena.tdb.base.reader.NodeTupleReader;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;

public class tdbcheck
extends CmdARQ {
    public static void main(String ... argv) {
        CmdUtils.setLog4j();
        String bulkLoaderClass = NTriplesReader2.class.getName();
        RDFReaderFImpl.setBaseReaderClassName((String)"N-TRIPLES", (String)bulkLoaderClass);
        RDFReaderFImpl.setBaseReaderClassName((String)"N-TRIPLE", (String)bulkLoaderClass);
        new tdbcheck(argv).mainRun();
    }

    protected tdbcheck(String[] argv) {
        super(argv);
    }

    protected String getSummary() {
        return this.getCommandName() + " FILE ...";
    }

    protected void exec() {
        List files = this.getPositional();
        if (files.size() == 0) {
            this.execOne(null);
            return;
        }
        for (String f : files) {
            this.execOne(f);
        }
    }

    private void execOne(String f) {
        GraphSinkCheck g = new GraphSinkCheck();
        Model model = ModelFactory.createModelForGraph((Graph)g);
        NodeTupleReader.CheckingIRIs = true;
        if (f != null) {
            if (this.isVerbose()) {
                System.out.println("File: " + f);
            }
            FileManager.get().readModel(model, f);
        } else {
            NodeTupleReader.CheckingNTriples = true;
            NodeTupleReader.CheckingIRIs = true;
            boolean forceISO8859 = false;
            if (forceISO8859) {
                this.forceISO8859();
            }
            NodeTupleReader.read((NodeTupleReader.TupleSink)new NodeTupleReader.NullSink(), System.in, null);
        }
    }

    private void forceISO8859() {
        InputStreamReader r = null;
        try {
            r = new InputStreamReader(System.in, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return;
        }
        NodeTupleReader.read((NodeTupleReader.TupleSink)new NodeTupleReader.NullSink(), (Reader)r, null);
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }

    static class GraphSinkCheck
    extends GraphSink {
        static IRIFactory iriFactory = IRIFactory.semanticWebImplementation();

        GraphSinkCheck() {
        }

        public void performAdd(Triple t) {
            this.check(t.getSubject());
            this.check(t.getPredicate());
            this.check(t.getObject());
        }

        private final void check(Node node) {
            if (node.isURI()) {
                this.checkURI(node);
            } else if (node.isBlank()) {
                this.checkBlank(node);
            } else if (node.isLiteral()) {
                this.checkLiteral(node);
            } else if (node.isVariable()) {
                this.checkVar(node);
            }
        }

        private final void checkVar(Node node) {
        }

        private final void checkLiteral(Node node) {
            String lang;
            LiteralLabel lit = node.getLiteral();
            if (lit.getDatatype() != null && !lit.isWellFormed()) {
                throw new JenaException("Lexical not valid for datatype: " + node);
            }
            if (lit.language() != null && (lang = lit.language()).length() > 0 && !lang.matches("[a-z]{1,8}(-[a-z]{1,8})*")) {
                throw new JenaException("Language not valid: " + node);
            }
        }

        private final void checkBlank(Node node) {
            String x = node.getBlankNodeLabel();
            if (x.indexOf(32) >= 0) {
                throw new JenaException("Illegal blank node label (contains a space): " + node);
            }
        }

        private final void checkURI(Node node) {
            boolean includeWarnings = true;
            IRI iri = iriFactory.create(node.getURI());
            if (iri.hasViolation(includeWarnings)) {
                Iterator it = iri.violations(includeWarnings);
                Violation vError = null;
                Violation vWarning = null;
                Violation vSub = null;
                while (it.hasNext()) {
                    Violation v2 = (Violation)it.next();
                    int code = v2.getViolationCode();
                    if (v2.isError()) {
                        vError = v2;
                        continue;
                    }
                    if (code == 11 || code == 1) {
                        if (vSub != null) continue;
                        vSub = v2;
                        continue;
                    }
                    vWarning = v2;
                    break;
                }
                if (vError != null) {
                    throw new JenaException(vError.getShortMessage());
                }
                if (vWarning != null) {
                    throw new JenaException(vWarning.getShortMessage());
                }
                if (vSub != null) {
                    throw new JenaException(vSub.getShortMessage());
                }
            }
        }
    }
}

