/*
 * Decompiled with CFR 0.152.
 */
package tdb.perf;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModVersion;
import com.hp.hpl.jena.sparql.util.Timer;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.block.BlockMgrMem;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFileSink;
import com.hp.hpl.jena.tdb.base.reader.NodeTupleReader;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexMem;
import com.hp.hpl.jena.tdb.nodetable.NodeTableBase;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderLib;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.store.BulkLoader;
import com.hp.hpl.jena.tdb.store.DatasetPrefixes;
import com.hp.hpl.jena.tdb.store.FactoryGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.Names;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import lib.ColumnMap;
import tdb.cmdline.CmdSub;
import tdb.cmdline.CmdTDB;

public class tdbperf
extends CmdSub {
    static final String CMD_PARSE = "parse";
    static final String CMD_LOAD = "load";
    static final String CMD_HELP = "help";
    static final String CMD_INFO = "info";

    public static void main(String ... argv) {
        new tdbperf(argv).exec();
    }

    protected tdbperf(String[] argv) {
        super(argv);
        super.addSubCommand(CMD_LOAD, new CmdSub.Exec(){

            @Override
            public void exec(String[] argv) {
                new SubLoad(argv).exec();
            }
        });
        super.addSubCommand(CMD_PARSE, new CmdSub.Exec(){

            @Override
            public void exec(String[] argv) {
                new SubParse(argv).exec();
            }
        });
        super.addSubCommand(CMD_HELP, new CmdSub.Exec(){

            @Override
            public void exec(String[] argv) {
                new SubHelp(argv).mainRun();
            }
        });
        super.addSubCommand(CMD_INFO, new CmdSub.Exec(){

            @Override
            public void exec(String[] argv) {
                new SubInfo(argv).mainRun();
            }
        });
    }

    static class SubInfo
    extends CmdTDB {
        public SubInfo(String ... argv) {
            super(argv);
        }

        protected String getSummary() {
            return "tdbperf info";
        }

        protected void exec() {
            System.out.println("-- " + Utils.nowAsString() + " --");
            ModVersion v = new ModVersion(true);
            v.addClass(TDB.class);
            v.printVersionAndExit();
        }

        @Override
        protected String getCommandName() {
            return "tdbperf info";
        }
    }

    static class SubHelp
    extends CmdARQ {
        public SubHelp(String ... argv) {
            super(argv);
        }

        protected String getSummary() {
            return null;
        }

        protected void exec() {
            System.out.println("Help!");
        }

        protected String getCommandName() {
            return "tdbperf help";
        }
    }

    static class SubParse {
        String[] args;

        public SubParse(String ... argv) {
            this.args = argv;
        }

        protected void exec() {
            NodeTupleReader.CountingSink sink = new NodeTupleReader.CountingSink();
            Timer timer = new Timer();
            timer.startTimer();
            List<String> files = Arrays.asList(this.args);
            for (String fn : files) {
                InputStream in = null;
                if (fn.equals("-") || fn.equals("--")) {
                    System.out.println("Parse: stdin");
                    in = System.in;
                } else {
                    System.out.println("Parse: " + fn);
                    try {
                        in = new FileInputStream(fn);
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                        break;
                    }
                }
                NodeTupleReader.read((NodeTupleReader.TupleSink)sink, in, fn);
                long x = timer.readTimer();
            }
            long x = timer.endTimer();
            double time = (double)x / 1000.0;
            long count = sink.count;
            if (time > 0.0) {
                System.out.printf("Triples: %,d: Time: %,.2f sec [%,.2f TPS]\n", count, time, (double)count / time);
            } else {
                System.out.printf("Triples: %,d: Time: %,.2f sec\n", count, time);
            }
            System.exit(0);
        }
    }

    static class SubLoad {
        String[] args;

        public SubLoad(String ... argv) {
            this.args = argv;
        }

        protected void exec() {
            TDB.init();
            GraphTDB g = SubLoad.setup1();
            TupleIndex[] z = g.getNodeTupleTable().getTupleTable().getIndexes();
            z[0] = new TupleIndexMem(3, new ColumnMap("SPO", "SPO"));
            z[1] = new TupleIndexMem(3, new ColumnMap("SPO", "POS"));
            z[2] = new TupleIndexMem(3, new ColumnMap("SPO", "OSP"));
            BulkLoader b = new BulkLoader(g, true);
            b.load(Arrays.asList(this.args));
            System.exit(0);
        }

        private static GraphTDB setup1() {
            BlockMgrMem.SafeMode = false;
            IndexBuilder indexBuilder = IndexBuilder.mem();
            Location location = null;
            ObjectFileSink objectFile = new ObjectFileSink();
            RecordFactory nr = FactoryGraphTDB.nodeRecordFactory;
            Index nodeToId = IndexBuilder.mem().newIndex(null, nr, "FOO");
            NodeTableBase nodeTable = new NodeTableBase(nodeToId, objectFile, SystemTDB.Node2NodeIdCacheSize, SystemTDB.NodeId2NodeCacheSize);
            TripleTable table = FactoryGraphTDB.createTripleTable(indexBuilder, nodeTable, location, Names.tripleIndexes);
            ReorderTransformation transform = ReorderLib.identity();
            DatasetPrefixes prefixes = new DatasetPrefixes(indexBuilder, location);
            return new GraphTriplesTDB(table, prefixes, transform, location);
        }
    }
}

