/*
 * Decompiled with CFR 0.152.
 */
package tdb.cmdline;

import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModSymbol;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import tdb.cmdline.ModTDBDataset;

public abstract class CmdTDB
extends CmdARQ {
    private static final ArgDecl argNamedGraph = new ArgDecl(true, "graph");
    protected String graphName = null;
    protected ModTDBDataset tdbDatasetAssembler = new ModTDBDataset();

    protected CmdTDB(String[] argv) {
        super(argv);
        CmdTDB.init();
        super.add(argNamedGraph, "--graph=IRI", "Act on a named graph");
        super.addModule((ArgModuleGeneral)this.tdbDatasetAssembler);
        this.modVersion.addClass(TDB.class);
    }

    public static void init() {
        TDB.init();
        ModSymbol.addPrefixMapping((String)"tdb", (String)"http://jena.hpl.hp.com/TDB#");
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(argNamedGraph)) {
            this.graphName = this.getValue(argNamedGraph);
        }
    }

    protected Model getModel() {
        if (this.graphName != null) {
            return this.tdbDatasetAssembler.getDataset().getNamedModel(this.graphName);
        }
        return this.tdbDatasetAssembler.getDataset().getDefaultModel();
    }

    protected Location getLocation() {
        return this.tdbDatasetAssembler.getLocation();
    }

    protected GraphTDB getGraph() {
        if (this.graphName != null) {
            return (GraphTDB)this.tdbDatasetAssembler.getDataset().getNamedModel(this.graphName).getGraph();
        }
        return (GraphTDB)this.tdbDatasetAssembler.getDataset().getDefaultModel().getGraph();
    }

    protected DatasetGraphTDB getDatasetGraph() {
        return (DatasetGraphTDB)this.getDataset().asDatasetGraph();
    }

    protected Dataset getDataset() {
        return this.tdbDatasetAssembler.getDataset();
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }
}

