/*
 * Decompiled with CFR 0.152.
 */
package lib.cache;

import lib.ActionKeyValue;
import lib.Cache;
import lib.cache.CacheWrapper;

public class CacheStats<Key, T>
extends CacheWrapper<Key, T> {
    private long cacheEntries = 0L;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private long cacheEjects = 0L;

    public CacheStats(Cache<Key, T> cache) {
        super(cache);
        cache.setDropHandler(new EjectMonitor(null));
    }

    @Override
    public synchronized T getObject(Key key) {
        if (this.cache.contains(key)) {
            ++this.cacheMisses;
        } else {
            ++this.cacheHits;
        }
        return (T)this.cache.getObject(key);
    }

    @Override
    public synchronized void putObject(Key key, T t) {
        T v = this.getObject(key);
        if (v == null) {
            ++this.cacheEntries;
            this.cache.putObject(key, v);
            return;
        }
        this.cache.putObject(key, v);
    }

    @Override
    public synchronized void removeObject(Key key) {
        if (this.cache.contains(key)) {
            --this.cacheEntries;
        }
        this.cache.removeObject(key);
    }

    @Override
    public synchronized void setDropHandler(ActionKeyValue<Key, T> dropHandler) {
        this.cache.setDropHandler(new EjectMonitor(dropHandler));
    }

    private class EjectMonitor
    implements ActionKeyValue<Key, T> {
        private ActionKeyValue<Key, T> other;

        EjectMonitor(ActionKeyValue<Key, T> other) {
            this.other = other;
        }

        @Override
        public void apply(Key key, T thing) {
            CacheStats.this.cacheEjects++;
            if (this.other != null) {
                this.other.apply(key, thing);
            }
        }
    }
}

