/*
 * Decompiled with CFR 0.152.
 */
package lib.cache;

import com.hp.hpl.jena.sparql.util.ALog;
import java.util.Iterator;
import lib.ActionKeyValue;
import lib.Cache;
import lib.CacheLRU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheNG<Key, T>
implements Cache<Key, T> {
    private static Logger log = LoggerFactory.getLogger(CacheNG.class);
    private int statsDumpTick = -1;
    private final boolean logging = false;
    private int max;
    private int min;
    CacheLRU.CacheImpl<Key, PoolEntry> objects;
    private long cacheEntries;
    private long cacheHits;
    private long cacheMisses;
    private long cacheEjects;
    private long cacheTimePoint = 0L;

    public CacheNG(int num) {
        this(0, num);
    }

    private CacheNG(int min, int max) {
        this.min = min;
        this.max = max;
        this.cacheEntries = 0L;
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cacheEjects = 0L;
        this.objects = new CacheLRU.CacheImpl(max);
        this.objects.setDropHandler(new ActionKeyValue<Key, PoolEntry>(){

            @Override
            public void apply(Key key, PoolEntry entry) {
                CacheNG.this.cacheEjects++;
            }
        });
    }

    @Override
    public synchronized boolean contains(Key key) {
        boolean b = this.objects.containsKey(key);
        return b;
    }

    @Override
    public T getObject(Key key) {
        return this.getObject(key, false);
    }

    public synchronized T getObject(Key key, boolean exclusive) {
        PoolEntry entry = (PoolEntry)this.objects.get(key);
        if (entry == null) {
            ++this.cacheMisses;
            this.stats();
            return null;
        }
        ++entry.cacheHit;
        if (exclusive) {
            if (entry.refCount > 0) {
                log.error("Attempt to get exclusive access when the object is already being shared: " + key);
                throw new CacheException("Failed to get exclusive access");
            }
            entry.refCount = -1;
            ++this.cacheHits;
            this.stats();
            return entry.thing;
        }
        if (entry.refCount < 0) {
            log.error("Attempt to get shared access when the object is already exclusively allocated: " + key);
            throw new CacheException("Failed to get shared access");
        }
        ++entry.refCount;
        ++this.cacheHits;
        this.stats();
        return entry.thing;
    }

    @Override
    public synchronized void putObject(Key key, T thing) {
        PoolEntry entry = (PoolEntry)this.objects.get(key);
        if (entry != null) {
            if (entry.thing.equals(thing)) {
                log.error("Putting the same object into the cache: " + key);
            }
            return;
        }
        ++this.cacheEntries;
        this.objects.put(key, new PoolEntry(key, thing));
        this.stats();
    }

    public synchronized void promote(Key key) {
        PoolEntry entry = (PoolEntry)this.objects.get(key);
        if (entry == null) {
            log.error("Attempt to promote object noit in the pool: " + key);
            throw new CacheException("Failed to promote");
        }
        if (entry.refCount < 0) {
            log.error("Attempt to promote object that is already exclusively allocated: " + key);
            throw new CacheException("Failed to promote");
        }
        if (entry.refCount == 0) {
            log.error("Attempt to promote object that is not allocated: " + key);
            throw new CacheException("Failed to promote");
        }
        if (entry.refCount > 1) {
            log.error("Attempt to promote object that is multiply shared: " + key);
            throw new CacheException("Failed to promote");
        }
        entry.refCount = -1;
        this.stats();
    }

    public synchronized void returnObject(Key key) {
        PoolEntry entry = (PoolEntry)this.objects.get(key);
        if (entry == null) {
            log.warn("Object returned that is not allocated: " + key);
            return;
        }
        if (entry.refCount < 0) {
            entry.refCount = 0;
            return;
        }
        --entry.refCount;
        this.stats();
    }

    @Override
    public synchronized void removeObject(Key key) {
        PoolEntry entry = (PoolEntry)this.objects.get(key);
        if (entry == null) {
            return;
        }
        this.objects.remove(key);
        --this.cacheEntries;
        this.stats();
    }

    @Override
    public Iterator<Key> keys() {
        return this.objects.keySet().iterator();
    }

    @Override
    public synchronized void clear() {
        this.objects.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public void setDropHandler(ActionKeyValue<Key, T> dropHandler) {
    }

    @Override
    public long size() {
        return this.objects.size();
    }

    private void stats() {
        long total = this.cacheMisses + this.cacheHits;
        if (total != 0L && total % (long)this.statsDumpTick == 0L) {
            String x = String.format("Size=%d, Hits=%d, Misses=%d, Ejects=%d", this.size(), this.cacheHits, this.cacheMisses, this.cacheEjects);
            log.info(x);
        }
    }

    private void warn(String message, Object ... args) {
        String x = String.format(message, args);
        ALog.warn((Object)this, (String)x);
    }

    private String str(Key key) {
        return key.toString();
    }

    private String str(PoolEntry entry) {
        return entry.key.toString() + " [" + entry.refCount + "]";
    }

    class PoolEntry {
        int refCount = 0;
        int cacheHit = 0;
        long cachePoint = 0L;
        T thing;
        private Object key;

        PoolEntry(Key key, T thing) {
            this.key = key;
            this.thing = thing;
            this.cachePoint = ++CacheNG.this.cacheTimePoint;
        }

        public String toString() {
            return String.format("[H:%d@%d] %s ", this.cacheHit, this.cachePoint, this.thing);
        }
    }

    static class CacheException
    extends RuntimeException {
        CacheException(String msg) {
            super(msg);
        }
    }
}

