/*
 * Decompiled with CFR 0.152.
 */
package lib.cache;

import iterator.SingletonIterator;
import java.util.Iterator;
import lib.ActionKeyValue;
import lib.Cache;

public class Cache1<K, V>
implements Cache<K, V> {
    private K cacheKey;
    private V cacheValue;

    public Cache1() {
        this.clear();
    }

    @Override
    public boolean contains(K key) {
        if (this.cacheKey == null) {
            return false;
        }
        return this.cacheKey.equals(key);
    }

    @Override
    public V getObject(K key) {
        if (this.cacheKey == null) {
            return null;
        }
        if (this.cacheKey.equals(key)) {
            return this.cacheValue;
        }
        return null;
    }

    @Override
    public void clear() {
        this.cacheKey = null;
        this.cacheValue = null;
    }

    @Override
    public boolean isEmpty() {
        return this.cacheKey == null;
    }

    @Override
    public Iterator<K> keys() {
        return new SingletonIterator<K>(this.cacheKey);
    }

    @Override
    public void putObject(K key, V thing) {
        this.cacheKey = key;
        this.cacheValue = thing;
    }

    @Override
    public void removeObject(K key) {
        if (this.cacheKey == null) {
            return;
        }
        if (this.cacheKey.equals(key)) {
            this.cacheKey = key;
            this.cacheValue = null;
        }
    }

    @Override
    public void setDropHandler(ActionKeyValue<K, V> dropHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() {
        return this.cacheKey == null ? 0L : 1L;
    }
}

