/*
 * Decompiled with CFR 0.152.
 */
package lib;

import iterator.Iter;
import java.util.Arrays;
import java.util.List;
import lib.ColumnMap;
import lib.Lib;

public final class Tuple<T> {
    final T[] tuple;

    public static <X> Tuple<X> blankTuple(int len) {
        Object[] tuple = new Object[len];
        return Tuple.create(tuple);
    }

    public static <X> Tuple<X> create(X ... elements) {
        return new Tuple<X>(elements);
    }

    private Tuple(T ... tuple) {
        this.tuple = tuple;
    }

    public T get(int idx) {
        return this.tuple[idx];
    }

    public int countNotNull() {
        int x = 0;
        for (T item : this.tuple) {
            if (item == null) continue;
            ++x;
        }
        return x;
    }

    public List<T> asList() {
        return Arrays.asList(this.tuple);
    }

    public T[] tuple() {
        return this.tuple;
    }

    public Tuple<T> map(ColumnMap colMap) {
        return colMap.map(this);
    }

    public Tuple<T> unmap(ColumnMap colMap) {
        return colMap.unmap(this);
    }

    public int size() {
        return this.tuple.length;
    }

    public int hashCode() {
        int x = 99;
        for (T n : this.tuple) {
            x = x << 1 ^ n.hashCode();
        }
        return x;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Tuple)) {
            return false;
        }
        Tuple x = (Tuple)other;
        if (x.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.tuple.length; ++i) {
            T obj1 = this.tuple[i];
            T obj2 = x.tuple[i];
            if (Lib.equals(obj1, obj2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "[" + Iter.asString(this.asList(), ", ") + "]";
    }
}

