/*
 * Decompiled with CFR 0.152.
 */
package lib;

import lib.ColumnMap;
import lib.Tuple;
import org.junit.Test;
import test.BaseTest;

public class TestColumnMap
extends BaseTest {
    @Test
    public void remap1() {
        ColumnMap x = new ColumnMap("SPO->POS", 2, 0, 1);
        Integer[] array = new Integer[]{0, 1, 2};
        TestColumnMap.assertEquals((Object)2, (Object)x.mapSlot(0, array));
        TestColumnMap.assertEquals((Object)0, (Object)x.mapSlot(1, array));
        TestColumnMap.assertEquals((Object)1, (Object)x.mapSlot(2, array));
    }

    @Test
    public void remap2() {
        ColumnMap x = new ColumnMap("SPO->POS", 2, 0, 1);
        Integer[] array = new Integer[]{0, 1, 2};
        TestColumnMap.assertEquals((Object)1, (Object)x.fetchSlot(0, array));
        TestColumnMap.assertEquals((Object)2, (Object)x.fetchSlot(1, array));
        TestColumnMap.assertEquals((Object)0, (Object)x.fetchSlot(2, array));
    }

    @Test
    public void remap3() {
        ColumnMap x = new ColumnMap("POS", 2, 0, 1);
        Tuple<String> tuple = Tuple.create("S", "P", "O");
        Tuple<String> mapped = x.map(tuple);
        Tuple<String> expected = Tuple.create("P", "O", "S");
        TestColumnMap.assertEquals(expected, mapped);
    }

    @Test
    public void remap4() {
        ColumnMap x = new ColumnMap("POS", 2, 0, 1);
        Tuple<String> tuple = Tuple.create("S", "P", "O");
        Tuple<String> tuple2 = x.map(tuple);
        tuple2 = x.unmap(tuple2);
        TestColumnMap.assertEquals(tuple, tuple2);
    }

    @Test
    public void compile1() {
        int[] x = ColumnMap.compileMapping("SPO", "POS");
        int[] expected = new int[]{2, 0, 1};
        TestColumnMap.assertArrayEquals((int[])expected, (int[])x);
    }

    @Test
    public void compile2() {
        int[] x = ColumnMap.compileMapping("SPOG", "GOPS");
        int[] expected = new int[]{3, 2, 1, 0};
        TestColumnMap.assertArrayEquals((int[])expected, (int[])x);
    }

    @Test
    public void map1() {
        ColumnMap cmap = new ColumnMap("GSPO", "OSPG");
        Tuple<String> tuple = Tuple.create("G", "S", "P", "O");
        Tuple<String> mapped = cmap.map(tuple);
        Tuple<String> expected = Tuple.create("O", "S", "P", "G");
        TestColumnMap.assertEquals(expected, mapped);
        Tuple<String> unmapped = cmap.unmap(mapped);
        TestColumnMap.assertEquals(Tuple.create("G", "S", "P", "O"), unmapped);
    }

    @Test
    public void map2() {
        String[] x = new String[]{"G", "S", "P", "O"};
        String[] y = new String[]{"O", "S", "P", "G"};
        ColumnMap cmap = new ColumnMap("Test", x, y);
        Tuple<String> tuple = Tuple.create(x);
        Tuple<String> mapped = cmap.map(tuple);
        Tuple<String> expected = Tuple.create(y);
        TestColumnMap.assertEquals(expected, mapped);
        Tuple<String> unmapped = cmap.unmap(mapped);
        TestColumnMap.assertEquals(Tuple.create(x), unmapped);
    }
}

