/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.nio.ByteBuffer;
import lib.Bytes;
import org.junit.Test;
import test.BaseTest;

public class TestBytes
extends BaseTest {
    private static final String asciiBase = "abc";
    private static final String latinBase = "\u00c0\u00e9\u00ed\u00ff";
    private static final String latinExtraBase = "\u1ef9\ufb01\ufb02";
    private static final String greekBase = "\u03b1\u03b2\u03b3";
    private static final String hewbrewBase = "\u05d0\u05d1\u05d2";
    private static final String arabicBase = "\u0621\u0622\u0623";
    private static final String symbolsBase = "\u263a\u263b\u266a\u266b";
    private static final String chineseBase = "\u5b6b\u5b50\u5175\u6cd5";
    private static final String japaneseBase = "\u65e5\u672c";

    @Test
    public void packInt1() {
        byte[] b = new byte[4];
        Bytes.setInt(16909060, b);
        TestBytes.assertEquals((long)1L, (long)b[0]);
        TestBytes.assertEquals((long)2L, (long)b[1]);
        TestBytes.assertEquals((long)3L, (long)b[2]);
        TestBytes.assertEquals((long)4L, (long)b[3]);
    }

    @Test
    public void packInt2() {
        byte[] b = new byte[8];
        Bytes.setInt(16909060, b, 0);
        Bytes.setInt(84281096, b, 4);
        TestBytes.assertEquals((long)1L, (long)b[0]);
        TestBytes.assertEquals((long)2L, (long)b[1]);
        TestBytes.assertEquals((long)3L, (long)b[2]);
        TestBytes.assertEquals((long)4L, (long)b[3]);
        TestBytes.assertEquals((long)5L, (long)b[4]);
        TestBytes.assertEquals((long)6L, (long)b[5]);
        TestBytes.assertEquals((long)7L, (long)b[6]);
        TestBytes.assertEquals((long)8L, (long)b[7]);
    }

    @Test
    public void packInt3() {
        byte[] b = new byte[4];
        Bytes.setInt(-235736076, b);
        int i = Bytes.getInt(b);
        TestBytes.assertEquals((long)-235736076L, (long)i);
    }

    @Test
    public void packInt4() {
        byte[] b = new byte[8];
        Bytes.setInt(16909060, b, 0);
        Bytes.setInt(84281096, b, 4);
        int i1 = Bytes.getInt(b, 0);
        int i2 = Bytes.getInt(b, 4);
        TestBytes.assertEquals((long)16909060L, (long)i1);
        TestBytes.assertEquals((long)84281096L, (long)i2);
    }

    @Test
    public void packLong5() {
        byte[] b = new byte[8];
        Bytes.setLong(72623859790382856L, b);
        TestBytes.assertEquals((long)1L, (long)b[0]);
        TestBytes.assertEquals((long)2L, (long)b[1]);
        TestBytes.assertEquals((long)3L, (long)b[2]);
        TestBytes.assertEquals((long)4L, (long)b[3]);
        TestBytes.assertEquals((long)5L, (long)b[4]);
        TestBytes.assertEquals((long)6L, (long)b[5]);
        TestBytes.assertEquals((long)7L, (long)b[6]);
        TestBytes.assertEquals((long)8L, (long)b[7]);
    }

    @Test
    public void packLong6() {
        byte[] b = new byte[16];
        Bytes.setLong(72623859790382856L, b, 0);
        Bytes.setLong(1230066625199609624L, b, 8);
        TestBytes.assertEquals((long)1L, (long)b[0]);
        TestBytes.assertEquals((long)2L, (long)b[1]);
        TestBytes.assertEquals((long)3L, (long)b[2]);
        TestBytes.assertEquals((long)4L, (long)b[3]);
        TestBytes.assertEquals((long)5L, (long)b[4]);
        TestBytes.assertEquals((long)6L, (long)b[5]);
        TestBytes.assertEquals((long)7L, (long)b[6]);
        TestBytes.assertEquals((long)8L, (long)b[7]);
        TestBytes.assertEquals((long)17L, (long)b[8]);
        TestBytes.assertEquals((long)18L, (long)b[9]);
        TestBytes.assertEquals((long)19L, (long)b[10]);
        TestBytes.assertEquals((long)20L, (long)b[11]);
        TestBytes.assertEquals((long)21L, (long)b[12]);
        TestBytes.assertEquals((long)22L, (long)b[13]);
        TestBytes.assertEquals((long)23L, (long)b[14]);
        TestBytes.assertEquals((long)24L, (long)b[15]);
    }

    @Test
    public void packLong7() {
        byte[] b = new byte[8];
        Bytes.setLong(-1012478732780767240L, b);
        long i = Bytes.getLong(b);
        TestBytes.assertEquals((long)-1012478732780767240L, (long)i);
    }

    @Test
    public void packLong8() {
        byte[] b = new byte[16];
        Bytes.setLong(-1012478732780767240L, b, 0);
        Bytes.setLong(-6799692559826901080L, b, 8);
        long i1 = Bytes.getLong(b, 0);
        long i2 = Bytes.getLong(b, 8);
        TestBytes.assertEquals((long)-1012478732780767240L, (long)i1);
        TestBytes.assertEquals((long)-6799692559826901080L, (long)i2);
    }

    private static void codec(String str) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        Bytes.toByteBuffer(str, bb);
        bb.flip();
        String str2 = Bytes.fromByteBuffer(bb);
        TestBytes.assertEquals((Object)str, (Object)str2);
    }

    @Test
    public void codec1() {
        TestBytes.codec(asciiBase);
    }

    @Test
    public void codec2() {
        TestBytes.codec("");
    }

    @Test
    public void codec3() {
        TestBytes.codec(greekBase);
    }

    @Test
    public void codec4() {
        TestBytes.codec(hewbrewBase);
    }

    @Test
    public void codec5() {
        TestBytes.codec(arabicBase);
    }

    @Test
    public void codec6() {
        TestBytes.codec(symbolsBase);
    }

    @Test
    public void codec7() {
        TestBytes.codec(chineseBase);
    }

    @Test
    public void codec8() {
        TestBytes.codec(japaneseBase);
    }
}

